/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

/**
 * An interface for handling tag start and tag end events that are recognized by the XML4J parser.
 * <p>Refer to the SAXDriver class for a sample implementation of this interface.  SAXDriver
 * implements this interface in order to propage events across the SAX API.
 *
 * @version Revision: 29 1.3 src/com/ibm/xml/parser/TagHandler.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public interface TagHandler {

    /**
     * Interface to be implemented in order to receive control when a start tag is recognized
     * by the parser.  Control is transferred prior to parsing any children.
     * @param   element TXElement that was parsed.
     * @param   empty   =true if the Element is an empty Element such as
     *                  <code>&lt;FOO key="val"/&gt;</code>; otherwise, =false.
     * @see #handleEndTag
     * @see com.ibm.xml.parser.SAXDriver#handleStartTag
     */
    public void handleStartTag(TXElement element, boolean empty);

    /**
     * Interface to be implemented in order to receive control when an end tag is recognized
     * by the parser.  Control is transferred prior to calling any ElementHandlers.
     * @param   element TXElement that was parsed.
     * @param   empty   =true if the Element has no children such as <code>&lt;FOO key="val"/&gt;</code>
     *                  or  or <code>&lt;FOO ...&gt;&lt;/FOO&gt;</code>; otherwise, =false.
     * @see #handleStartTag
     * @see com.ibm.xml.parser.SAXDriver#handleEndTag
     * @see com.ibm.xml.parser.ElementHandler
     */
    public void handleEndTag(TXElement element, boolean empty);
}
