/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser;

/**
 * XML4J tree traversal exception which signals from a Visitor to the tree traversal algorithm
 * that further traversal of the current Node's children should be ended because the visit on 
 * this portion of thee document object hierarchy has been successfully completed.  For
 * example, the MakeDigestVisitor throws this exception when a digest already exists on a
 * given Node, and there is no need to traverse children of this Node.  Note that this exception
 * constitutes a request that a traversal algorithm is free to ignore.
 *
 * @version Revision: 69 1.2 src/com/ibm/xml/parser/ToNextSiblingTraversalException.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author ROWE Tom &lt;trowe@us.ibm.com&gt;
 * @see com.ibm.xml.parser.NonRecursivePreorderTreeTraversal#traverse 
 * @see com.ibm.xml.parser.MakeDigestVisitor 
 * @see com.ibm.xml.parser.TreeTraversalException
 */
public class ToNextSiblingTraversalException extends TreeTraversalException {

    /**
     * Constructor for exception with no detail message.
     */
    public ToNextSiblingTraversalException() {
        super();
    }

    /**
     * Constructor for exception with detail message.
     * @param msg       The detail message for the exception.
     */
    public ToNextSiblingTraversalException(String msg) {
        super(msg);
    }
}
