/*
 * (C) Copyright IBM Corp. 1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */
 
package com.ibm.xml.parser;

import org.w3c.dom.*;

/**
 * TreeTraversal defines the document object tree traversal mechanisms for used by the
 * visitor design pattern.  
 *
 * @version Revision: %M% %I% %W% %Q%
 * @author ROWE Tom &lt;trowe@us.ibm.com&gt;
 * @see com.ibm.xml.parser.NonRecursivePreorderTreeTraversal
 */
public abstract class TreeTraversal {
    
    private Visitor visitor =   null;
    
    /**
     * Constructor.
     * @param   visitor The implemention of the Visitor operation (toXMLString, digest, ...)
     * @see com.ibm.xml.parser.Visitor
     */
    public TreeTraversal(Visitor visitor) {
        this.visitor = visitor;
    }

    /**
     * Returns the Visitor operation currently active in this tree traversal.
     * @return  visitor The implemention of the Visitor operation (toXMLString, digest, ...)
     * @see com.ibm.xml.parser.Visitor
     */
    public Visitor getVisitor() {
        return(this.visitor);
    }

    /**
     * Traverses the document object tree at the specified <var>startNode</var>.
     * @param   startNode   The starting point to begin traversing the document object tree.
     * @see com.ibm.xml.parser.NonRecursivePreorderTreeTraversal#traverse
     * @exception Exception Thrown if the tree could not be traversed.
     */
    public abstract void traverse(Node startNode) throws Exception;

}  //TreeTraversal

