/*
 * (C) Copyright IBM Corp. 1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */
 
package com.ibm.xml.parser;

/**
 * An interface of the visitor design pattern which defines the accept operations when 
 * a Node is recognized when traversing the document object tree.
 *
 * @version Revision: %M% %I% %W% %Q%
 * @author ROWE Tom &lt;trowe@us.ibm.com&gt;
 * @see com.ibm.xml.parser.Child
 * @see com.ibm.xml.parser.TXDocument#acceptPre
 * @see com.ibm.xml.parser.TXElement#acceptPre
 * @see com.ibm.xml.parser.TXAttribute#acceptPre
 * @see com.ibm.xml.parser.TXPI#acceptPre
 * @see com.ibm.xml.parser.TXComment#acceptPre
 * @see com.ibm.xml.parser.TXText#acceptPre
 * @see com.ibm.xml.parser.DTD#acceptPre
 * @see com.ibm.xml.parser.ElementDecl#acceptPre
 * @see com.ibm.xml.parser.Attlist#acceptPre
 * @see com.ibm.xml.parser.AttDef#acceptPre
 * @see com.ibm.xml.parser.EntityDecl#acceptPre
 * @see com.ibm.xml.parser.TXNotation#acceptPre
 * @see com.ibm.xml.parser.GeneralReference#acceptPre
 * @see com.ibm.xml.parser.PseudoNode#acceptPre
 */

public interface Visitee {
    
    /**
     * Interface to be implemented which defines the accept operation of the visitor design 
     * pattern when the start of a Node is recognized when traversing the document object tree. 
     * @param   visitor     The implemention of the Visitor operation (toXMLString, digest, ...)
     * @exception Exception Thrown if this Node can not be visitted, or traversal modification is requested.
     * @see #acceptPost
     * @see com.ibm.xml.parser.Visitor
     * @see com.ibm.xml.parser.TreeTraversal
     * @see com.ibm.xml.parser.NonRecursivePreorderTreeTraversal
     * @see com.ibm.xml.parser.TreeTraversalException
     */
    public void acceptPre(Visitor visitor) throws Exception;

    /**
     * Interface to be implemented which defines the accept operation of the visitor design 
     * pattern when the end of a Node is recognized when traversing the document object tree. 
     * @param   visitor     The implemention of the Visitor operation (toXMLString, digest, ...)
     * @exception Exception Thrown if this Node can not be visitted, or traversal modification is requested.
     * @see #acceptPre
     * @see com.ibm.xml.parser.Visitor
     * @see com.ibm.xml.parser.TreeTraversal
     * @see com.ibm.xml.parser.NonRecursivePreorderTreeTraversal
     * @see com.ibm.xml.parser.TreeTraversalException
     */
    public void acceptPost(Visitor visitor) throws Exception;

}
