#
# Revision: 01 1.16 src/com/ibm/xml/parser/makeit.ksh, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
#

#
# Make script for com/ibm/xml/parser directory.
#


. setupEnvVars.ksh


THISDIR=com/ibm/xml/parser
THISCLASSDIR=$XML4JCLASSFILESDIR/$THISDIR
SRCDIR=.

SRCFILES="
                AttDef.java 
                Attlist.java 
                CM1op.java 
                CM2op.java 
                CMLeaf.java 
                CMNode.java 
                Child.java 
                ContentModel.java 
                DTD.java 
                EbcdicToAsciiInputStream.java
                ElementDecl.java 
                ElementHandler.java
                EndTraversalException.java
                EntityPool.java 
                ErrorListener.java 
                ExternalID.java 
                FileScanner.java 
                FormatPrintVisitor.java 
                GeneralReference.java 
                InsertableElement.java 
                InvalidEncodingException.java 
                LibraryException.java 
                MIME2Java.java 
                MakeDigestVisitor.java
                Match.java 
                Namespace.java 
                NOOPVisitor.java
                NoRequiredAttributeHandler.java 
                NonRecursivePreorderTreeTraversal.java
                PIHandler.java 
                Parent.java 
                ParsePoint.java 
                Parser.java 
                PreRootHandler.java 
                PseudoNode.java 
                Reading.java 
                ReferenceHandler.java 
                SAXDriver.java 
                Source.java 
                Stderr.java 
                StreamProducer.java 
                StringPool.java 
                StringReading.java 
                StylesheetPI.java 
                ToNextSiblingTraversalException.java
                ToXMLStringVisitor.java
                TreeTraversal.java
                TreeTraversalException.java
                TXAttribute.java 
                TXAttributeList.java 
                TXCDATASection.java 
                TXCharacterData.java 
                TXComment.java 
                TXDOMException.java 
                TXDocument.java 
                TXDocumentFragment.java 
                TXElement.java 
                TXNodeList.java 
                TXNotation.java 
                TXPI.java 
                TXText.java 
                TagHandler.java 
                Token.java 
                Util.java 
                Version.java 
                Visitee.java
                Visitor.java
                XMLChar.java 
                XMLCharGen.java 
                XMLReader.java"

case $# in
    0)  target=all;;
    *)  target=$1;;
esac

case $target in 
    all)          javac $JAVACFLAGS $SRCFILES;
                  mesg="Finished compiling all files in $THISDIR.";;
    veryclean)    rm -f $THISCLASSDIR/*.class;
                  mesg="Finished cleanup in $THISDIR.";;
    *)            echo "Target '$target' not recognized.";
                  mesg="Finished processing '$target' in $THISDIR.";;
esac

for i in r util
do
    if test -d $i
    then
        echo Building $target in directory $THISDIR/$i.
        sh -c "cd $i; ./makeit.ksh $target"
    else
        echo Skipping directory $THISDIR/$i.
    fi
done

echo $mesg
exit


#
# XMLChar.java is created from XMLChar.java.h and XMLChar.java.t and XMLCharGen.
# The body of XMLChar.java is generated by running the java program XMLCharGen.
# 
# We have already generated the file XMLChar.java. It checked into the
# source control repository. It is also included in the makefile.
#
# The following rule on how to generate the file XMLChar.java is mentioned just
# incase the file has to be created from scratch again.
#
# FOR NOW WE SHALL COMMENT THIS FILE GENERATION RULE.
#

# XMLChar.class: XMLChar.java.h XMLChar.java.t XMLChar.java.body
# 	cat XMLChar.java.h XMLChar.java.body XMLChar.java.t > XMLChar.java
# 	javac $(JAVACFLAGS) XMLChar.java

# XMLChar.java.body: XMLCharGen.class
# 	$(JAVA) com.ibm.xml.parser.XMLCharGen range > XMLChar.java.body
