/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parser.r;
 
/**
 * <p>
 * This file contains error and warning messages used by the IBM
 * XML for Java parser. The messages are arranged in key and value
 * tuples in a ListResourceBundle. All keys have prefixes to 
 * categorize the type of message associated with the key. These
 * prefixes are described in the following table.
 * </p>
 *
 * <div align="center">
 * <p>
 * <table border=1 cellpadding=4>
 * <tr>
 * <th>Key Prefix</th>
 * <th>Meaning</th>
 * </tr>
 * <tr>
 * <td align="center"><tt>E_xxx</tt></td>
 * <td>Parse error or well-formedness constraint failure.</td>
 * </tr>
 * <tr>
 * <td align="center"><tt>V_xxx</tt></td>
 * <td>Validity constraint failure.</td>
 * </tr>
 * <tr>
 * <td align="center"><tt>W_xxx</tt></td>
 * <td>Warning.</td>
 * </tr>
 * </table>
 * </p>
 * </div>
 *
 * @version Revision: 50 1.12 src/com/ibm/xml/parser/r/Message.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @author Andy Clark, IBM
 */
public class Message
    extends java.util.ListResourceBundle 
    {
    /** The list resource bundle contents. */
    public static final Object CONTENTS[][] = {
        { "E_!0", "\"<!--\" or \"<![CDATA[\" expected." },
        //{ "E_!1", "\"<!--\" or \"<!DOCTYPE\" expected." },
        { "E_ATTD0", "Attribute name expected." },
        //{ "E_ATTD1", "`NOTATION'' is expected." },
        { "E_ATTD2", "Attribute type expected. (e.g. \"CDATA\", \"ID\", \"ENTITY\", etc.)" },
        { "E_ATTD3", "Invalid attribute default declaration. \"#\" must be followed by \"REQUIRED\", \"IMPLIED\", or \"FIXED\"." },
        { "E_ATTD4", "Attribute default declaration expected. (\"#REQUIRED\", \"#IMPLIED\", or \"#FIXED\")" },
        //{ "E_ATTD5", "Syntax error in ATTLIST." },
        { "E_ATTEQ0", "''='' expected after attribute name, \"{0}\"." },
        { "E_ATTEQ1", "Duplicate attribute name, \"{0}\"." },
        { "W_ATTEQ2", "Invalid language identifier, \"{0}\", specified for attribute name \"xml:lang\"." },
        { "E_ATTL0", "Element name expected." },
        //{ "E_ATTL1", "Syntax error in ATTLIST: `{0}''" },
        { "V_ATTL2", "Duplicate attribute, \"{0}\", specified." },
        { "V_ATTL3", "An attribute \"{0}\" declared as ID must be #REQUIRED or #IMPLIED." },
        { "W_ATTL1", "Warning: attribute \"xml:space\" is recommended to be declared as \"xml:space (default|preserve) #IMPLIED\"." },
        { "W_ATTL2", "Warning: attribute \"{0}\" is already declared." },
        { "E_ATTVAL0", "' or \" expected. Attribute value must be quoted." },
        { "E_ATTVAL1", "Attribute value must not contain '<'." },
        { "E_CDATA0", "\"<!--\" or \"<![CDATA[\" expected." },
        { "E_CDATA1", "\"<![CDATA[\" must end with \"]]>\"." },
        { "E_COM0", "Comment must start with \"<!--\"." },
        { "E_COM1", "Comment must end with \"-->\"." },
        { "E_COM2", "Comment must not contain \"--\"." },
        { "E_COND0", "\"<![INCLUDE[\" or \"<![IGNORE[\" expected." },
        { "E_COND1", "\"<![INCLUDE[\" or \"<![IGNORE[\" must end with \"]]>\"." },
        { "E_COND3", "\"<?\" or \"<!\" expected." },
        { "V_CONT0", "Element \"<{0}>\" is not valid in this context." },
        { "V_CONT1", "Element \"<{0}>\" is not valid because it does not follow the rule, \"{1}\"." },
        //{ "E_CS0", "A name is expected." },
        { "E_CS1", "Element content sequence token expected. ('|', ',', or ')')" },
        { "E_CS2", "\"PCDATA\" expected. \"#\" must be followed by \"PCDATA\"." },
        { "E_CS3", "')' expected." },
        //{ "E_CS4", "\")*\" is expected." },
        { "E_CS5", "'(' or element name expected." },
        { "E_CS6", "Invalid operator, ''{0}''.  (Previous operator was ''{1}''.)" },
        //{ "V_CS7", "A parameter entity in content models must include proper pairs of parenthesises and not be empty and neither the first nor last character should be `,'' or `|'': `{0}''" },
        //{ "E_CS8", "`('' is expected: `{0}''" },
        { "E_CS9", "Content model, \"{0}\", must match the mixed model \"(#PCDATA|foo|...|bar)*\"." },
        { "E_CSa", "Content model must match the mixed model \"(#PCDATA|foo|...|bar)*\"." },
        { "E_DOCTYPE0", "\"<!--\" or \"<!DOCTYPE\" expected." },
        { "E_DOCTYPE1", "No root element type name." },
        { "E_DOCTYPE2", "Unknown external identifier, \"{0}\". \"SYSTEM\" or \"PUBLIC\" expected." },
        { "E_DOCTYPE3", "DTD is empty." },
        { "E_DTD0", "Invalid character, ''{0}'', in DTD. (Unicode: 0x{1})" },
        { "E_DTD1", "\"<?\" or \"<!\" expected." },
        { "E_DTD2", "Unknown declaration type, \"{0}\". Must be \"ELEMENT\", \"ATTLIST\", \"ENTITY\", or \"NOTATION\"." },
        { "E_DTD3", "Declaration type expected. Must be \"ELEMENT\", \"ATTLIST\", \"ENTITY\", or \"NOTATION\"." },
        { "E_DTD4", "Conditional section only allowed in external subset." },
        { "E_ELEM0", "Element name expected." },
        { "E_ELEM1", "\"EMPTY\", \"ANY\", or '(' expected." },
        { "E_ELEM2", "'>' expected." },
        { "V_ELEM3", "Duplicate element name, \"{0}\"." },
        { "E_ENC0", "Unsupported encoding, \"{0}\"." },
        { "E_ENC1", "Invalid XML character. (Unicode: 0x{0})" },
        { "E_ENC2", "Invalid UTF-16 surrogate. (bytes: 0x{0} 0x{1})" },
        { "E_ENC3", "Invalid UTF-16 code. (byte: 0x{0})" },
        { "E_ENC4", "Invalid UTF-8 code. (byte: 0x{0})" },
        { "E_ENC5", "Invalid UTF-8 code. (bytes: 0x{0} 0x{1})" },
        { "E_ENC6", "Invalid UTF-8 code. (bytes: 0x{0} 0x{1} 0x{2})" },
        { "E_ENC7", "Invalid UTF-8 code. (bytes: 0x{0} 0x{1} 0x{2} 0x{3})" },
        { "E_ENTITY0", "Undefined entity reference, \"&{0};\"." },
        { "E_ENTITY1", "Invalid ENTITY declaration. Name expected." },
        { "E_ENTITY2", "NDATA reference, \"&{0};\", is invalid in this context." },
        { "E_ENTITY3", "Invalid XML character. (Unicode: 0x{0})" },
        { "E_ENTITY4", "'>' expected." },
        { "E_ENTITY5", "Invalid entity declaration. NDATA expected." },
        { "W_ENTITY6", "Warning: Entity name, \"{0}\", already defined. This declaration will be ignored." },
        { "E_ENTITY7", "External entity reference, \"&{0};\", is not allowed here." },
        { "V_ENTITY8", "NDATA type, \"{0}\", is not declared by \"<!NOTATION>\"." },
        { "V_ENTITY9", "External entity, \"&{0};\", is not allowed in standalone document." },
        { "E_ENTITYa", "Parameter entity references is not allowed here." },
        { "E_ENUM0", "')' expected." },
        { "E_ENUM1", "Invalid name enumeration, \"(Name | Name | ...)\"." },
        { "E_ENUM2", "Invalid name token enumeration, \"(Nmtoken | Nmtoken | ...)\"." },
        { "E_ENUM3", "'|' or ')' expected." },
        //{ "E_ENUM4", "Value `{0}'' is already specified." },
        { "E_ENUM5", "NOTATION, \"{0}\", is not declared." },
        { "E_EOF", "Unexpected end of file." },
        { "E_EXT0", "Whitespace expected." },
        { "E_EXT1", "' or \" expected. Public identifier must be quoted." },
        { "E_EXT2", "Invalid character, ''{0}'', in public identifier." },
        { "E_EXT3", "' or \" expected. System identifier must be quoted." },
        { "E_EXT4", "Invalid character, ''{0}'', in system identifier, \"{1}\"." },
        { "E_EXT5", "Space or '>' expected." },
        { "V_IDREF0", "Identifier, \"{0}\", is not defined in the document." },
        { "E_INVCHAR0", "Invalid XML character. (Unicode: 0x{0})" },
        { "E_INVENC0", "Invalid encoding. Big-endian UCS-2 with no byte order mark." },
        { "E_INVENC1", "Invalid encoding. Little-endian UCS-2 with no byte order mark." },
        { "E_IO0", "File, \"{0}\", not found." },
        { "E_NAMES0", "\"{0}\" contains invalid character." },
        { "E_NMTOK0", "\"{0}\" contains invalid character." },
        { "E_NOT0", "Invalid NOTATION declaration. Name expected." },
        { "E_PEREF0", "Parameter entity name expected." },
        { "E_PEREF1", "Parameter reference, \"%{0};\", not terminated with '';''." },
        { "V_PEREF2", "Undefined parameter reference, \"%{0};\"." },
        //{ "E_PEREF3", "A parameter reference `%{0};'' is not within single markup declaration: \"{1}\"" },
        //{ "E_PEREF4", "In an internal subset of DTD, parameter entity references within markup declarations are not allowed." },
        { "E_PEREF5", "Recursive reference \"%{0};\". (Reference path: {1})" },
        //{ "E_PEREF6", "Parameter-entity replacement text must not be empty in content model: `%{0};''" },
        { "V_PEREF7", "Parameter entity replacement text must include proper pairs of parentheses in content model, \"%{0};\"." },
        //{ "E_PEREF8", "Neither the first nor last character in parameter-entity replacement text must be `,'' or `|'': `%{0};''" },
        { "V_PEREF9", "Parameter entity replacement text must include declarations or proper pairs of ''<'' and ''>''. (entity: \"%{0};\")" },
        { "E_PI0", "Processing instruction name expected." },
        //{ "E_PI1", "No space after PI target name." },
        { "E_PI2", "Processing instruction data expected." },
        { "E_PI3", "\"?>\" expected." },
        { "E_PI4", "Invalid encoding name, \"{0}\"." },
        { "E_PI5", "A processing instruction starting with \"[xX][mM][lL]\" is not allowed." },
        { "E_PI6", "Invalid parameter, \"{0}\", in processing instruction declaration." },
        { "E_PI7", "No \"encoding\" parameter specified." },
        { "E_REFER0", "Invalid character, ''{0}'', in reference." },
        { "E_REFER1", "Reference must end with ';'." },
        { "E_REFER2", "Number expected." },
        { "E_REFER3", "Character reference, \"&#x{0}\", is out of range." },
        { "E_REFER4", "Character reference, \"&#{0};\", is out of range." },
        { "E_SPACE", "Whitespace expected." },
        { "E_STRUCT0", "Invalid document structure." },
        { "E_STRUCT1", "Document must start with \"<?xml\"." },
        { "E_STRUCT2", "Document must contain root element." },
        { "E_STRUCT3", "DOCTYPE must be placed before root element." },
        { "W_STRUCT4", "Warning: No \"<?xml version=\"1.0\"?>\" found." },
        { "W_STRUCT5", "Warning: No \"<!DOCTYPE ...>\" found." },
        { "E_TAG0", "Element name expected." },
        { "E_TAG1", "\"/>\" or '>' expected." },
        { "E_TAG3", "\"</{0}>\" expected." },
        { "E_TAG4", "'>' expected." },
        { "V_TAG5", "Document root element, \"{1}\", must match DOCTYPE root, \"{0}\"." },
        { "V_TAG6", "Attribute, \"{0}\", is not declared in element, \"{1}\"." },
        { "V_TAG7", "Invalid character, ''{0}'', in attribute value." },
        { "V_TAG8", "Duplicate identifier, \"{0}\"." },
        { "V_TAG9", "Invalid attribute value, \"{0}\"." },
        { "V_TAGa", "Attribute value, \"{0}\", is not binary external entity." },
        { "V_TAGb", "Invalid attribute value, \"{0}\". No NOTATION declared for \"{0}\"." },
        { "V_TAGc", "Required attribute, \"{0}\", is not specified." },
        { "V_TAGd", "Invalid value, \"{2}\", specified for attribute, \"{0}\". (default value: \"{1}\")" },
        { "E_TAGe", "\"{0}\" may only have one name space separator, '':''." },
        { "E_TAGf", "Name space expected in \"{0}\"." },
        { "E_TAGg", "Unexpected end tag." },
        { "E_TAGh", "General entity can only have entire elements, references, CDATA, processing instructions, and text." },
        { "E_TAGi", "Recursive reference, \"&{0};\". (reference path: {1})" },
        { "E_TAGj", "Text must not contain \"]]>\"." },
        //{ "E_TAGk", "Element `{0}'' is declared as `EMPTY''.  `/>'' is expected." },
        { "E_TAGl", "Attribute, \"{0}\", value expected." },
        //{ "E_TAGm", "Attribute `{0}'' (`{1}'' as namespace, `{2}'' as localPart) is already specified as `{3}'' in the same tag." },
        { "E_TAGm", "Attribute \"{0}\" is already specified as \"{3}\". (namespace: \"{1}\", local: \"{2}\")" },
        { "E_XML0", "\"?>\" expected." },
        { "E_XML1", "Attribute, \"version\", is required." },
        { "E_XML2", "Attribute, \"version\", must be specified first." },
        { "E_XML3", "Invalid \"standalone\" attribute value, \"{0}\". Must be \"yes\" or \"no\"." },
        { "E_XML4", "Unsupported XML version." },
        { "E_XML5", "Unknown attribute, \"{0}\", or invalid attribute order." },
        { "E_XML6", "Invalid XML version format, \"{0}\"." },
        //{ "E_XMLNS0", "No `ns'' parameter in a Namespace PI." },
        //{ "E_XMLNS1", "No `prefix'' parameter in a Namespace PI." },
        //{ "E_XMLNS2", "`prefix'' value `{0}'' is invalid as namespace prefix." },
        //{ "E_XMLNS3", "A namespace `{0}'' is already used." },
        //{ "E_XMLNS4", "An attribute `{0}'' is not recognized in Namespace PI." },
        { "E_XMLSS0", "Attribute, \"{0}\", is not recognized in style sheet processing instruction." },
        { "E_XMLSS1", "Style sheet processing instruction must contain \"type\" parameter." },
        { "E_XMLSS2", "Style sheet processing instruction must contain \"href\" parameter." },
        };

    /** Returns the list resource bundle contents. */
    public Object[][] getContents() {
        return CONTENTS;
        }

    } // class Message
