/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.xpointer;

/**
 * The AttrTerm class provides support for attribute location terms in XPointers. 
 * Absolute and relative location terms have as their target one or more elements.  In order
 * to allow attributes within an element to be the target of an XPointer, the attribute location
 * term is provided.
 * <p>An attribute term specifies a location in terms of another location, called the location 
 * source.  The location source is the entire resource if there are no preceding location 
 * terms; otherwise it is the location specified by the preceding term (which might be 
 * relative to a location term before that). 
 * <p>The attribute term has the single keyword <code>attr</code> which takes only an 
 * attribute name as a selector and returns the attribute's value.  
 * <p>Following is an example of an attribute XPointer that returns the value of the attribute
 * named <code>department</code> of the element with ID <code>a23</code>: <code>id(a23).attr(department)</code>
 *
 * @version Revision: 73 1.4 src/com/ibm/xml/xpointer/AttrTerm.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see com.ibm.xml.xpointer.XPointer
 * @see com.ibm.xml.xpointer.OtherTerm
 */

public class AttrTerm implements OtherTerm {
    
        String  name    =   null;

    /**
     * Constructor.
     * @param   name    Name of the attribute in this attribute term.
     */
    public AttrTerm(String name) {
        this.name = name;
    }

    /**
     * Returns the name of the attribute in this attribute term.
     * @return          Name of the attribute in this attribute term.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Returns this attribute term in the form of <code>attr(<var>name</var>)</code>.
     * @return          A string represention of this attribute term.
     */
    public String toString() {
        return "attr("+this.name+")";
    }
}
