/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.xpointer;

/**
 * The SpanTerm class provides support for span location terms in XPointers.  
 * Many XPointers locate individual nodes in an element tree. However, some location terms 
 * can locate more complex sets of data. For example, a string match may locate only a 
 * portion of a node, and an XPointer containing the span location term (called a spanning 
 * XPointer) can reference sub-resources that do not constitute whole elements.
 * <p>The span term has the single keyword <code>span</code> which locates a sub-resource starting 
 * at the beginning of the data selected by its first argument and continuing through to the 
 * end of the data selected by its second argument. Both arguments are interpreted relative 
 * to the location source for the spanning location term itself; the second argument does not 
 * use the first argument as its location source.
 * <p>Following is an example of a spanning XPointer that selects the first through third 
 * children of the element with ID <code>a23</code>: <code>id(a23).span(child(1),child(3))</code>
 *
 * @version Revision: 79 1.5 src/com/ibm/xml/xpointer/SpanTerm.java, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 * @see com.ibm.xml.xpointer.XPointer
 * @see com.ibm.xml.xpointer.OtherTerm
 */

public class SpanTerm implements OtherTerm, java.io.Serializable {
    
            static final long serialVersionUID = 48993678655481497L;
            XPointer    xbegin  =   null;
            XPointer    xend    =   null;

    /**
     * Constructor.
     * @param   xbegin  The XPointer which denotes the start of the sub-resource to be selected. 
     * @param   xend    The XPointer which denotes the end of the sub-resource to be selected. 
     */
    public SpanTerm(XPointer xbegin, XPointer xend) {
        this.xbegin = xbegin;
        this.xend   = xend;
    }

    /**
     * Returns the XPointer which denotes the start of the selected sub-resource.
     * @return      The start of the selected sub-resource.
     * @see #getEnd
     */
    public XPointer getBeginning() {
        return this.xbegin;
    }

    /**
     * Returns the XPointer which denotes the end of the selected sub-resource.
     * @return      The end of the selected sub-resource.
     * @see #getEnd
     */
    public XPointer getEnd() {
        return this.xend;
    }

    /**
     * Returns this span term in the form of <code>span(<var>xbegin</var>,<var>xend</var>)</code>.
     * @return          A string represention of this span term.
     */
    public String toString() {
        return "span("+this.xbegin+","+this.xend+")";
    }
}
