#
# Revision: 97 1.5 src/makeit.ksh, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
#

#
# Make script for ../src directory.
#


. setupEnvVars.ksh



THISDIR=
THISCLASSDIR=$XML4JCLASSFILESDIR/$THISDIR
SRCDIR=.


SRCFILES=

case $# in
    0)  target=all;;
    *)  target=$1;;
esac

case $target in 
    all)
#                 Create the $XML4JCLASSFILESDIR, if necessary.
                  if test ! -d $XML4JCLASSFILESDIR
                  then
                      mkdir $XML4JCLASSFILESDIR;
                  fi
                  echo "Compiling all files in src root directory...";
                  mesg="Finished compiling all files in src root directory.";;
    veryclean)    echo "Cleaning up in src root directory...";
                  mesg="Finished cleanup in src root directory.";;
    *)            echo "Target '$target' not recognized.";
                  mesg="Finished processing '$target' in src root directory.";;
esac

for i in org/w3c/dom org/xml/sax com/ibm/xml
do
    if test -d $i
    then
        echo Building $target in directory $THISDIR/$i.
        sh -c "cd $i; ./makeit.ksh $target"
    else
        echo Skipping directory $THISDIR/$i.
    fi
done

echo $mesg
exit
