#
# Revision: 07 1.7 src/org/w3c/dom/makeit.ksh, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
#

#
# Make script for org/w3c/dom directory.
#


. setupEnvVars.ksh


THISDIR=org/w3c/dom
THISCLASSDIR=$XML4JCLASSFILESDIR/$THISDIR
SRCDIR=.

SRCFILES="
                Attr.java
                CDATASection.java
                CharacterData.java
                Comment.java
                DOMException.java
                DOMImplementation.java
                Document.java
                DocumentFragment.java
                DocumentType.java
                Element.java
                Entity.java
                EntityReference.java
                NamedNodeMap.java
                Node.java
                NodeList.java
                Notation.java
                ProcessingInstruction.java
                Text.java"

case $# in
    0)  target=all;;
    *)  target=$1;;
esac

case $target in 
    all)          javac $JAVACFLAGS $SRCFILES;
                  mesg="Finished compiling all files in $THISDIR.";;
    veryclean)    rm -f $THISCLASSDIR/*.class;
                  mesg="Finished cleanup in $THISDIR.";;
    *)            echo "Target '$target' not recognized.";
                  mesg="Finished processing '$target' in $THISDIR.";;
esac

for i in html
do
    if test -d $i
    then
        echo Building $target in directory $THISDIR/$i.
        sh -c "cd $i; ./makeit.ksh $target"
    else
        echo Skipping directory $THISDIR/$i.
    fi
done

echo $mesg
exit
