#
# Revision: 08 1.4 src/org/xml/sax/makeit.ksh, xml4jsrc, xml4j-jtcsv, xml4j_1_1_16 
#

#
# Make script for org/xml/sax directory.
#


. setupEnvVars.ksh

THISDIR=org/xml/sax
THISCLASSDIR=$XML4JCLASSFILESDIR/$THISDIR
SRCDIR=.

SRCFILES="
                AttributeList.java
                DTDHandler.java
                DocumentHandler.java
                EntityResolver.java
                ErrorHandler.java
                HandlerBase.java
                InputSource.java
                Locator.java
                Parser.java
                SAXException.java
                SAXParseException.java"


case $# in
    0)  target=all;;
    *)  target=$1;;
esac

case $target in 
    all)          javac $JAVACFLAGS $SRCFILES;
                  mesg="Finished compiling all files in $THISDIR.";;
    veryclean)    rm -f $THISCLASSDIR/*.class;
                  mesg="Finished cleanup in $THISDIR.";;
    *)            echo "Target '$target' not recognized.";
                  mesg="Finished processing '$target' in $THISDIR.";;
esac

for i in helpers
do
    if test -d $i
    then
        echo Building $target in directory $THISDIR/$i.
        sh -c "cd $i; ./makeit.ksh $target"
    else
        echo Skipping directory $THISDIR/$i.
    fi
done

echo $mesg
exit
