/* Configure Timidity++ 2.7.0 (and probably above) for OS/2. */

config_h='config.h'
timi_make='timidity\Makefile'
interface_h='interface.h'
inter_make='interface\Makefile'
EMXIncTest='os2emx.h'
TlkIncTest='bsedos.h'
EMXLibTest='emxio.a'
string_h='string.h'

say '*** ConfigOS/2: Checking/Setting OS/2 environment'

/* Locate EMX include, Warp Toolkit include and EMX library directories */
EMXInc=EScan('C_INCLUDE_PATH',EMXIncTest)
if EMXInc='' then EMXInc=EScan('CPLUS_INCLUDE_PATH',EMXIncTest)
if EMXInc='' then EMXInc=EScan('INCLUDE',EMXIncTest)
if EMXInc='' then do
   say 'Unable to determine EMX include directory'
   exit(1)
   end
TlkInc=EScan('C_INCLUDE_PATH',TlkIncTest)
if TlkInc='' then TlkInc=EScan('CPLUS_INCLUDE_PATH',TlkIncTest)
if TlkInc='' then TlkInc=EScan('INCLUDE',TlkIncTest)
if TlkInc='' then do
   say 'Unable to determine Warp Toolkit include directory'
   exit(1)
   end
EMXLib=EScan('LIBRARY_PATH',EMXLibTest)
if EMXLib='' then EMXLib=EScan('LIBPATH',EMXLibTest)
if EMXLib='' then do
   say 'Unable to determine EMX library directory'
   exit(1)
   end
PatchSTRNCASE='N'
Temp=translate(EMXInc,'\','/')
if right(Temp,1)<>'\' then Temp=Temp'\'
Temp=insert(Temp,string_h)
if stream(Temp,'c','query exists')='' then do
   say 'File not found:' Temp
   exit(1)
   end
do while chars(Temp)<>0
   Next=linein(Temp)
   if (word(Next,1)='#define')&(word(Next,2)='strncasecmp') then PatchSTRNCASE='Y'
   end
call stream Temp,'c','close'

call value 'C_INCLUDE_PATH',EMXInc,'OS2ENVIRONMENT'
call value 'CPLUS_INCLUDE_PATH',EMXInc,'OS2ENVIRONMENT'
call value 'LIBRARY_PATH',EMXLib,'OS2ENVIRONMENT'
call value 'GCCOPT','-pipe','OS2ENVIRONMENT'

/*say 'EMXInc:' EMXInc
say 'TlkInc:' TlkInc
say 'EMXLib:' EMXLib
say 'Need HAVE_STRNCASECMP patch:' PatchSTRNCASE
exit(0)*/

say '*** ConfigOS/2: Running configure script'

'@bash configure --disable-esdtest --disable-alsatest --disable-gtktest --host=i586-linux'

call LoadFile config_h
if PatchSTRNCASE='Y' then call HeaderVar 'HAVE_STRNCASECMP','#define'
call HeaderVar 'HAVE_USLEEP','#define'
call HeaderVar 'HAVE_NCURSES_CURSES_H','#define'
call SaveFile

call LoadFile timi_make
call MakeVar 'SYSEXTRAS','dart_a.c'
call MakeVar 'CPPFLAGS','-I'EMXInc '-I'TlkInc '-DAU_DART -DDEFAULT_PATH=\"./\"'
call MakeVar 'LDFLAGS','-L'EMXLib '-L'EMXLib'/ncurses'
call MakeVar 'LIBS','-lsocket -lm -los2me -lvideo -lncurses'
call MakeVar 'DEFS','-D__EMX__ -DHAVE_CONFIG_H -I. -I$(srcdir) -I.. -I..'
call SaveFile

call LoadFile interface_h
call HeaderVar 'IA_SLANG','#define'
call HeaderVar 'IA_NCURSES','#define'
call SaveFile

call LoadFile inter_make
call MakeVar 'libinterface_a_SOURCES','dumb_c.c wrdt_dumb.c wrdt_tty.c slang_c.c ncurs_c.c'
call MakeVar 'CPPFLAGS','-I'EMXInc '-I. -DAU_OSS $(DEF_PKGDATADIR) $(DEF_PKGLIBDIR) $(DEF_DEFAULT_PATH) -DTIMIDITY_OUTPUT_ID=\"d\"'
call MakeVar 'libinterface_a_OBJECTS','dumb_c.o wrdt_dumb.o wrdt_tty.o slang_c.o ncurs_c.o'
call MakeVar 'DEFS','-D__EMX__ -DHAVE_CONFIG_H -I. -I$(srcdir) -I.. -I..'
call SaveFile

say '*** ConfigOS/2: Configuration complete'
exit(0)

/* Load arg(1) into File. stem, store name in FileName */
LoadFile:
   procedure expose File. FileName
   FileName=arg(1)

   say '*** ConfigOS/2: Patching' FileName
   if (stream(FileName,'c','query exists')='') then do
      say 'File not found:' FileName
      exit(1)
      end
   i=0
   do while chars(FileName)<>0
      i=i+1
      File.i=linein(FileName)
      end
   File.0=i
   call stream FileName,'c','close'
   return

/* Save File. stem to FileName */
SaveFile:
   procedure expose File. FileName

   '@del' FileName
   i=0
   do i=1 to File.0
      call lineout FileName,File.i
      end
   call stream FileName,'c','close'
   drop File.
   drop FileName
   return

/* replace probably disabled arg(1) definition in File stem with arg(2) arg(1) */
HeaderVar:
   procedure expose File. FileName
   var=arg(1)

   do i=1 to File.0
      l=File.i
      if (word(l,2)<>'') then do
         if (word(l,1)='/*')|(word(l,1)='//') then l=substr(l,wordindex(l,2))
         if ((word(l,1)='#define')|(word(l,1)='#undef'))&(word(l,2)=var) then do
            File.i=arg(2) var
            return
            end
         end
      end
   say 'Definition not found:' var 'in' FileName
   exit(1)
/* no return */

/* replace arg(1) value in File stem with arg(2) */
MakeVar:
   procedure expose File. FileName
   var=arg(1)

   do i=1 to File.0
      l=File.i
      if (word(l,1)=var)&(word(l,2)='=') then do
         File.i=var '=' arg(2)
         return
         end
      end
   say 'Variable not found:' var 'in' FileName
   exit(1)
/* no return */

/* Scan environment var arg(1) for a directory with file arg(2) */
EScan:
   procedure
   var=value(arg(1),,'OS2ENVIRONMENT')
   file=arg(2)
   ret=''
   do while (var<>'')&(ret='')
      if pos(';',var)<>0 then do
         dir=left(var,pos(';',var)-1)
         var=substr(var,pos(';',var)+1)
         end
      else do
         dir=var
         var=''
         end
      dir=translate(strip(dir),'\','/')
      do while pos(':',dir)<>0
         dir=substr(dir,pos(':',dir)+1)
         end
      if dir<>'' then do
         if right(dir,1)<>'\' then dir=dir'\'
         if stream(insert(dir,file),'c','query exists')<>'' then ret=dir
         end
      end
   if length(ret)>1 then if right(ret,1)='\' then ret=left(ret,length(ret)-1)
   return translate(ret,'/','\')

