/* Patch Timidity++ 2.8.2 (and probably above) for OS/2.
   NOTE: You must run it only once on a just uncompressed source !
   */

dart_a="timidity\dart_a.c"
slang_h="interface\slang.h"
configure="configure"
output_c="timidity\output.c"
output_h="timidity\output.h"
playmidi_c="timidity\playmidi.c"
ncurs_c="interface\ncurs_c.c"

say '*** PatchOS/2: Checking the distributive'
if stream(dart_a,'c','query exists')='' then do
   say 'You should copy' dart_a 'from the OS/2 version distribution.'
   exit(1)
   end
if stream(slang_h,'c','query exists')='' then do
   say 'You should copy' slang_h 'from the OS/2 version distribution.'
   exit(1)
   end

call LoadFile configure
Step=0
i=1
do while i<=File.0
   Next=File.i
   select
      when Step=0 then
         if pos('checking whether the C compiler',Next)<>0 then Step=1
      when Step=1 then 
         if Next='ac_ext=c' then do
            call InsertLine 'ac_exeext=.exe',i
            Step=2
            end
      when Step=2 then
         if pos('if test -n "$RANLIB"; then',Next)<>0 then Step=3
      when Step=3 then do
         p=pos('if test -f $ac_dir/$ac_word; then',Next)
         if p<>0 then do
            File.i="    if test -f $ac_dir/$ac_word$ac_exeext; then"
            Step=4
            end
         end
      otherwise nop
      end
   i=i+1
   end
if Step<>4 then do
   say 'Inconsistent contents in' configure
   exit(1)
   end
call SaveFile

call LoadFile output_c
Step=0
i=1
do while i<=File.0
   Next=File.i
   select
      when Step=0 then
         if pos('#elif defined(AU_BSDI)',Next)<>0 then Step=1
      when Step=1 then 
         if pos('#define DEV_PLAY_MODE',Next)<>0 then do
            call InsertLine "",i
            call InsertLine "#elif defined(AU_DART)",i+1
            call InsertLine "extern PlayMode dart_play_mode;",i+2
            call InsertLine "#define DEV_PLAY_MODE &dart_play_mode",i+3
            i=i+3
            Step=2
            end
      otherwise nop
      end
   i=i+1
   end
if Step<>2 then do
   say 'Inconsistent contents in' output_c
   exit(1)
   end
call SaveFile

call LoadFile output_h
i=1
do while i<=File.0
   Next=File.i
   if pos('#define FILE_OUTPUT_MODE	O_WRONLY|O_CREAT|O_TRUNC|O_BINARY, 0644',Next)<>0 then do
      call InsertLine "#elif defined(__EMX__)",i
      call InsertLine Next,i+1
      i=i+2
      end
   i=i+1
   end
call SaveFile

call LoadFile playmidi_c
call HeaderVar 'REDUCE_VOICE_TIME_TUNING','// #define'
call SaveFile

call LoadFile ncurs_c
call HeaderVar 'WREFRESH_CACHED','// #define'
call SaveFile

say '*** PatchOS/2: Complete'
exit(0)

/* Insert arg(1) after line no arg(2) in File. stem */
InsertLine:
   procedure expose File. FileName
   i=arg(2)

   if i>File.0 then i=File.0
   if i<File.0 then do
      do j=File.0+1 to i+1 by -1
         jj=j-1
         File.j=File.jj
         end
      end
   i=i+1
   File.i=arg(1)
   File.0=File.0+1
   return

/* Load arg(1) into File. stem, store name in FileName */
LoadFile:
   procedure expose File. FileName
   FileName=arg(1)

   say '*** PatchOS/2: Patching' FileName
   if (stream(FileName,'c','query exists')='') then do
      say 'File not found:' FileName
      exit(1)
      end
   i=0
   do while chars(FileName)<>0
      i=i+1
      File.i=linein(FileName)
      end
   File.0=i
   call stream FileName,'c','close'
   return

/* Save File. stem to FileName */
SaveFile:
   procedure expose File. FileName

   '@del' FileName
   i=0
   do i=1 to File.0
      call lineout FileName,File.i
      end
   call stream FileName,'c','close'
   drop File.
   drop FileName
   return

/* replace probably disabled arg(1) definition in File stem with arg(2) arg(1) */
HeaderVar:
   procedure expose File. FileName
   var=arg(1)

   do i=1 to File.0
      l=translate(File.i,' ',D2C(9))
      if (word(l,2)<>'') then do
         if (word(l,1)='/*')|(word(l,1)='//') then l=substr(l,wordindex(l,2))
         if ((word(l,1)='#define')|(word(l,1)='#undef'))&(word(l,2)=var) then do
            File.i=arg(2) var
            return
            end
         end
      end
   say 'Definition not found:' var 'in' FileName
   exit(1)
/* no return */
