/* Parse GnuFrog homepage for gnutella host addresses */

/* get the gnufrog index */
'@wget -P . -nd http://www.gnufrog.com/'
filen = "index.html"

/* check for the file */
if stream(filen, 'c', 'query exists') = '' then exit

/* create path to phex hostfile */
call get_java_home
hostfile = RESULT ||"\phex\phex.hosts"

/* collect the hosts */
call get_hosts filen

/* create hosts file */
call write_hosts hostfile

exit /*Main*/



/* Find the java13 path -- this gives the
   path to the phex config directory */
get_java_home:
jpth = SysIni(,'Java13','USER_HOME')
if jpth = "ERROR:" then
   do
     say "Java13 not found";
     exit 1;
   end; /* then-do */
   else
   do
   parse upper var jpth jp 'JRE' junk;
   /* echo "Java13 location is " jp; */
   jp = jp ||"jre"
   end; /* else-do */
return jp



/* parses the GNUfrog file */
get_hosts: procedure expose hosts.
arg fn
do i = 1 while lines(fn)
   parse value linein(fn,(i)) with junk 'host=' hosts.i '"' junk2
   end /* do */
hosts.0 = i - 1
return

/* write the hosts file */
write_hosts: procedure expose hosts.
arg fn
TMPhst = "newhosts.tmp"
tempdir = value('TEMP', , 'OS2ENVIRONMENT')
if tempdir == '' then tempdir = directory()
if right(tempdir, 1) <> '\' then tempdir = tempdir || '\'
TMPhst = tempdir || TMPhst
do i = 1 to hosts.0
   if hosts.i <>"" then call lineout TMPhst, hosts.i
end /* do hosts */
call lineout TMPhst, ''
call stream TMPhst, 'C', 'CLOSE'
'@COPY' TMPhst fn
call SysFileDelete TMPhst
return



