/*
** $Id: install.cmd,v 1.1 1998/08/05 02:31:23 ahuber Exp $
**
** Create a jCVS folder and install the program object and the
** HTML documentation.
**
** Copyright (C) 1998  Andreas Huber <ahuber@ping.at>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; see the file COPYING. If not, write to
** the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
** Boston, MA 02111-1307, USA.
*/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

EXIT_SUCCESS = 0
EXIT_FAILURE = 1

LOCATION = '<JCVS_FOLDER>'

NL = d2c(13)||d2c(10)

globals = 'EXIT_SUCCESS EXIT_FAILURE LOCATION argc argv. NL'

main:
	argc = 2; argv. = ''; argv.0 = 'install'; argv.1 = arg(1)
	if argv.1 \= '' then
		install_dir = directory(argv.1)
	else
		install_dir = directory()
	call make_jcvs
	call make_folder 'jCVS'
	call make_javapm install_dir||'/application', 'jCVS',,
		'./jcvs.jar', 'com.ice.jcvs.CVSApplication'
	call make_file_url 'Read me!', install_dir||'/doc/README.html'
	exit EXIT_SUCCESS

make_jcvs: procedure expose (globals)
	'cd source'
	'javac -O -depend com\ice\jcvs\CVSApplication.java'
	'jar -cf ..\application\jcvs.jar',
		'com\ice\jcvs\*.class',
		'com\ice\cvsc\*.class',
		'com\ice\jcvs\images\*.gif',
		'com\ice\jcvs\images\icons\*.gif'
	'del com\ice\jcvs\*.class >nul 2>&1'
	'del com\ice\cvsc\*.class >nul 2>&1'
	'cd ..'
	return

make_folder: procedure expose (globals) LOCATION
	parse arg title
	if \SysCreateObject('WPFolder', title, '<WP_DESKTOP>',,
			'OBJECTID='||LOCATION, 'update') then
		call die 'Cannot create folder.'
	return

make_javapm: procedure expose (globals) LOCATION
	parse arg dir, title, classpath, class
	dir = translate(dir, '\', '/')
	classpath = classpath||';'||find_classes()
	classpath = translate(classpath, '\', '/')
	classpath = escape_path(classpath)
	if \SysCreateObject('WPProgram', title, LOCATION,,
			'PROGTYPE=PM;EXENAME=JAVAPM.EXE;STARTUPDIR='||dir||';'||,
			'PARAMETERS=-classpath' classpath class, 'update') then
		call die 'Cannot create program object.'
	return

make_file_url: procedure expose (globals) LOCATION
	parse arg title, path
	path = translate(path, '\', '/')
	call make_url title, 'file:///'||path
	return

make_url: procedure expose (globals) LOCATION
	parse arg title, url
	if \SysCreateObject('WPUrl', title, LOCATION,,
			'URL='||url, 'update') then
		call die 'Cannot create URL object.'
	return

escape_path: procedure expose (globals)
	parse arg path
	i = 1
	do forever
		i = pos(';', path, i)
		if i = 0 then leave
		path = insert('^', path, i-1);
		i = i+2
	end
	return path

find_classes: procedure expose (globals)
	java_home = value('JAVA_HOME',, 'OS2ENVIRONMENT')
	if java_home \= '' then
		return java_home||'\lib\classes.zip'
	classpath = value('CLASSPATH',, 'OS2ENVIRONMENT')
	do forever
		parse var classpath classes ';' classpath
		if classes = '' then
			call die ,
'Couldn''t find lib\classes.zip in either your %JAVA_HOME%'||NL,
' directory or in your %CLASSPATH%. Set the JAVA_HOME environment'||NL,
' variable to point to your Java home directory and retry.'
		if translate(right(classes, 16)) = '\LIB\CLASSES.ZIP' then leave
	end
	return classes

die: procedure expose (globals)
	parse arg text
	call lineout 'stderr:', argv.0||': '||text
	exit EXIT_FAILURE

