


CTAGS(1)                                                 CTAGS(1)


NAME
       ctags - Generate tag files for source code



SYNOPSIS
       ctags [options] [file(s)]

       etags [options] [file(s)]



DESCRIPTION
       The  ctags  and  etags  programs (hereinafter collectively
       referred to as ctags, except where distinguished) generate
       an index (or "tag") file for a variety of language objects
       found in file(s).  This tag file allows these items to  be
       quickly and easily located by a text editor or other util-
       ity. A "tag" signifies a  language  object  for  which  an
       index  entry  is  available  (or, alternatively, the index
       entry created for that object).


       Alternatively, ctags can generate a cross  reference  file
       which lists, in human readable form, information about the
       various source objects found in a set of language files.


       Tag index files are supported by numerous  editors,  which
       allow the user to locate the object associated with a name
       appearing in a source file and jump to the file  and  line
       which  defines  the name. Those known about at the time of
       release are:


           vi(1) and its many derivatives (e.g. Vim, Vile, Lemmy)
           CRiSP
           emacs
           FTE (Folding Text Editor)
           NEdit (Nirvana Edit)
           TSE (The SemWare Editor)
           X2
           Zeus


       Ctags  is  capable  of  generating tags for indicated con-
       tructs of the following languages:



           Assembler:
               labels

           AWK:



Darren Hiebert         Version 4.0.1                      1





CTAGS(1)                                                 CTAGS(1)


               functions

           BETA:
               fragments
               patterns
               slots

           Bourne shell:
               functions

           C/C++:
               macros (names defined/undefined by #define/#undef)
               enumerators (enumerated values)
               function definitions, prototypes, and declarations
               class, enum, struct, and union names
               namespaces
               typedefs
               variables (definitions and declarations)
               class, struct, and union members

           COBOL:
               paragraphs

           Eiffel:
               classes
               features
               local entities

           Fortran:
               block data
               common blocks
               entry points
               functions
               interfaces
               labels
               modules
               namelists
               programs
               subroutines
               derived types

           Java:
               classes
               fields
               interfaces
               methods
               packages

           Lisp:
               functions

           Perl:
               subroutines




Darren Hiebert         Version 4.0.1                      2





CTAGS(1)                                                 CTAGS(1)


           Python:
               classes
               functions

           Scheme:
               functions
               sets

           Tcl:
               procedures

           Vim:
               functions



SOURCE FILES
       Unless the --lang option is  specified,  the  language  of
       each  source file is automatically selected based upon its
       file extension, if recognized. If the  file  extension  is
       unknown  and the file is executable, the first line of the
       file is checked to see if the file is a "#!" script for  a
       recognized lanaguage. File extensions are mapped to source
       file languages according to the following default  mapping
       (unless the --langmap option is specified):


           Assembler
                    *.asm *.s *.S
           AWK      *.awk
           C        *.c
           C++      *.C *.c++ *.cc *.cpp *.cxx *.h *.H *.hh *.hpp
                    *.hxx *.h++
           BETA     *.bet
           Bourne shell
                    *.sh *.SH *.bsh *.bash *.ksh
           COBOL    *.cob *.COB
           Eiffel   *.e
           Fortran  *.f *.for *.ftn *.f77 *.f90 *.f95  *.F  *.FOR
                    *.FTN *.F77 *.F90 *.F95
           Java     *.java
           Lisp     *.cl *.clisp *.el *.l *.lisp *.lsp *.ml
           Perl     *.pl *.pm *.perl
           Python   *.py *.python
           Scheme   *.sch *.scheme *.scm *.sm *.SCM *.SM
           Tcl      *.tcl *.wish
           Vim      *.vim


       By  default,  all other files extensions are ignored. This
       permits running ctags on all  files  in  either  a  single
       directory  (e.g.  "ctags  *"),  or  all files in an entire
       source directory tree (e.g. "ctags -R"), since only  those
       files whose extensions are known to ctags will be scanned.



Darren Hiebert         Version 4.0.1                      3





CTAGS(1)                                                 CTAGS(1)


       The reason that .h extensions  are  mapped  to  C++  files
       rather  than C files is because no information is lost and
       because it is common to use .h extensions  in  C++,  where
       information  would  be lost if .h files were parsed with C
       rules.



OPTIONS
       Despite the wealth of available options, defaults are  set
       so  that  ctags  is  most  commonly  executed  without any
       options (e.g. "ctags *"), which will create a tag file  in
       the  current  directory  for  all  known source files. The
       options described below are provided merely to allow  cus-
       tom tailoring to meet special needs.


       Note that spaces separating the single-letter options from
       their parameters are optional.


       Note also that the boolean parameters  to  the  long  form
       options  (those  beginning  with  "--"  and  that  take  a
       "=yes|no" parameter) may be omitted, in which case  "=yes"
       is  implied.  (e.g.  --sort  is equivalent to --sort=yes).
       Note further that "=1" and "=on" are  considered  synonyms
       for  "=yes",  and that "=0" and "=off" are considered syn-
       onyms for "=no".

       Some options are either ignored, or only useful, when used
       together  with  etags  or, equivalently, when ctags is run
       with the -e option. These options will be noted.

       Most options may appear  anywhere  on  the  command  line,
       affecting  only those files which follow the option. A few
       options, however, must appear before the first  file  name
       and will be noted as such.


       -a   Equivalent to --append.


       -B   Use  backward  searching  patterns  (e.g.  ?regexp?).
            [Ignored with -e]


       -e   Output a tag file for use with Emacs. If this program
            is executed by the name etags, this option is enabled
            by default. This option must appear before the  first
            file name.


       -f tagfile
            Use  the  name  specified by tagfile for the tag file



Darren Hiebert         Version 4.0.1                      4





CTAGS(1)                                                 CTAGS(1)


            (default is "tags",  or  "TAGS"  when  using  the  -e
            option). If tagfile is specified as "-", then the tag
            file is written to  standard  output  instead.  Ctags
            will  stubbornly  refuse  to  take  orders if tagfile
            exists and its first line  contains  something  other
            than  a  valid tags line. This will save your neck if
            you mistakenly type "ctags -f *.c", which would  oth-
            erwise overwrite your first C file with the tags gen-
            erated by the rest! This option  must  appear  before
            the first file name. If this option is specified more
            than once, only the last will apply.


       -F   Use  forward  searching  patterns   (e.g.   /regexp/)
            (default).  [Ignored with -e]


       -h list
            Specifies  a  list  of  file extensions, separated by
            periods, which are to be interpreted as  include,  or
            header, files. To indicate files having no extension,
            use a period not followed by a  non-period  character
            (e.g.  ".",  "..x",  ".x."). This option only affects
            how the scoping of tag  types  is  interpreted  (i.e.
            whether  or not they are considered as globally visi-
            ble or visible only within the file in which they are
            defined);  it  does not map the extension to any par-
            ticular language. Any tag type which is located in  a
            non-include  file and cannot be seen (e.g. linked to)
            from another file is considered to have  file-limited
            (e.g.  static)  scope.  No  tag  type appearing in an
            include file will be considered to have  file-limited
            scope.  If  the first character in the list is a plus
            sign,  then  the  extensions  in  the  list  will  be
            appended  to  the  current  list; otherwise, the list
            will replace the current list. See also  the  --file-
            scope     option.     The     default     list     is
            ".h.H.hh.hpp.hxx.h++.inc.def". To restore the default
            list,  specify  -h default. Note that if an extension
            supplied to this option is not already  mapped  to  a
            particular  language  (see  SOURCE FILES, above), you
            will also need to use either the --langmap or  --lan-
            guage option.


       -i types
            This option is deprecated and will be dropped at some
            point in the future.  It is similar to the  --c-types
            option and is retained for compatibility with earlier
            versions. If types begins with the '=' character,  it
            is  equivalent  to  --c-types=types. Otherwise, it is
            equivalent  to  --c-types=+types.  In  addition,  for
            backward  compatibility, the following two additional
            modifiers are accepted:



Darren Hiebert         Version 4.0.1                      5





CTAGS(1)                                                 CTAGS(1)


               F   An alternative for the --file-tags option.
               S   An alternative for the --file-scope option.


       -I tokenlist
            Specifies a list of tokens which are to be  specially
            handled  while  parsing  C and C++ source files. This
            option is specifically  provided  to  handle  special
            cases arising through the use of preprocessor macros.
            When the  tokens  listed  are  simple  tokens,  these
            tokens  will  be ignored during parsing of the source
            files. If a token is suffixed with a  '+'  character,
            ctags will also ignore any parenthesis-enclosed argu-
            ment list which may immediately follow the  token  in
            the  source  files.  If two tokens are separated with
            the '=' character, the first token is replaced by the
            second token for parsing purposes. The list of tokens
            may be supplied directly on the command line or  read
            in  from  a  separate file. If the first character of
            tokenlist is either a '.'  or  a  pathname  separator
            ('/'  or  '\'), or the first two characters specify a
            drive letter (e.g.  "C:"),  the  parameter  tokenlist
            will  be interpreted as a filename from which to read
            a list of white-space delimited tokens (use  "./file-
            name"  to  specify a file found in the current direc-
            tory). Otherwise, tokenlist is a list of  tokens  (or
            token  pairs) to be specially handled, each delimited
            by a either a comma or by white space (in which  case
            the  list should be quoted to keep the entire list as
            one command line argument).  Multiple -I options  may
            be supplied. To clear the list of ignore tokens, sup-
            ply a single dash ("-") for tokenlist.


            This feature is useful when preprocessor  macros  are
            used  in  such a way that they cause syntactic confu-
            sion due to their presence. Indeed, this is the  best
            way  of working around a number of problems caused by
            the presence of syntax-busting macros in source files
            (see BUGS, below). Some examples will illustrate this
            point.


               int foo ARGDECL4(void *, ptr, long int, nbytes)


            In the above example, the macro "ARGDECL4"  would  be
            mistakenly interpreted to be the name of the function
            instead of the correct name of "foo".  Specifying  -I
            ARGDECL4 results in the correct behavior.


               /* creates an RCS version string in module */
               MODULE_VERSION("$Revision: 8.40 $")



Darren Hiebert         Version 4.0.1                      6





CTAGS(1)                                                 CTAGS(1)


            In  the  above example the macro invocation looks too
            much like a function definition  because  it  is  not
            followed  by  a  semicolon  (indeed, it could even be
            followed by a global variable definition  that  would
            look  much like a K&R style function parameter decla-
            ration). In fact, this  seeming  function  definition
            could  possibly even cause the rest of the file to be
            skipped over while trying to complete the definition.
            Specifying  -I  MODULE_VERSION+  would  avoid  such a
            problem.


               CLASS Example {
                   // your content here
               };


            The example above  uses  "CLASS"  as  a  preprocessor
            macro  which  expands to something different for each
            platform. For instance CLASS may be defined as "class
            __declspec(ddlexport)"  on Win32 platforms and simply
            "class" on UNIX.  Normally, the absence  of  the  C++
            keyword  "class"  would  cause  the source file to be
            incorrectly parsed. Correct behavior can be  restored
            by specifying -I CLASS=class.


       -L file
            Read  from  file  a list of file names for which tags
            should be generated.  If file is  specified  as  "-",
            then  file  names  are read from standard input. File
            names read using this option are processed  following
            file names appearing on the command line. Options all
            also accepted in this input. If this option is speci-
            fied  more than once, only the last will apply. Note:
            file is read in line-oriented mode, where a new  line
            is  the only delimiter and spaces are considered sig-
            nificant, in order that file names containing  spaces
            may  be  supplied;  this  can  affect how options are
            parsed if included in the input.


       -n   Equivalent to --excmd=number.


       -N   Equivalent to --excmd=pattern.


       -o tagfile
            Equivalent to -f tagfile.


       -p path
            Use path as the default directory for  each  supplied



Darren Hiebert         Version 4.0.1                      7





CTAGS(1)                                                 CTAGS(1)


            source  file (whether supplied on the command line or
            in a file specified with the -L option),  unless  the
            source file is already specified as an absolute path.
            The supplied path is merely  prepended  to  the  each
            non-absolute  source  file name (adding any necessary
            path separator) before attempting to open it.


       -R   Equivalent to --recurse.


       -u   Equivalent to --sort=no (i.e. "unsorted").


       -V   Equivalent to --verbose.


       -x   Print  a  tabular,  human-readable  cross   reference
            (xref)  file to standard output instead of generating
            a tag file. The information contained in  the  output
            includes:  the  tag  name;  the kind of tag; the line
            number, file name, and source line (with extra  white
            space  condensed)  of the file which defines the tag.
            No tag file is written and all options affecting  tag
            file output will be ignored. Example applications for
            this feature are generating a listing  of  all  func-
            tions  located  in  a source file (e.g. ctags -x --c-
            types=f file), or generating a list of all externally
            visible  global  variables  located  in a source file
            (e.g. ctags  -x  --c-types=v  --file-scope=no  file).
            This option must appear before the first file name.


       --append=yes|no
            Indicates  whether  tags generated from the specified
            files should be appended to those already present  in
            the  tag  file or should replace them. This option is
            off by default. This option must  appear  before  the
            first file name.  [Ignored with -e]


       --beta-types=types
            Specifies  a  list  of  BETA language tag types to be
            included in the output.  See --c-types for the  defi-
            nition of the format of types. Tags for the following
            BETA language constructs  are  supported  (types  are
            enabled by default except as noted):


               f   fragment definitions
               p   all patterns [off]
               s   slots (fragment uses)
               v   patterns (only virtual or rebound patterns are
                   recorded)



Darren Hiebert         Version 4.0.1                      8





CTAGS(1)                                                 CTAGS(1)


       --c-types=types
            Specifies a list  of  C/C++  language  tag  types  to
            include in the output file.  The parameter types is a
            group of one-letter flags designating types  of  tags
            (listed  below) to either include or exclude from the
            output. Each letter or group of letters may  be  pre-
            ceded  by either '+' to add it to the default set, or
            '-' to exclude it. In the absence  of  any  preceding
            '+'  or  '-' sign, only those types explicitly listed
            in types will be included in the output  (i.e.  over-
            riding  the  default). For example, to exclude macros
            but  include  prototypes,  use   --c-types=-d+p;   to
            include  only  tags  for  functions, use --c-types=f.
            Tags for the following language constructs  are  sup-
            ported  (types  are  enabled  by  default  except  as
            noted):


               c   classes
               d   macro definitions (and #undef names)
               e   enumerators
               f   function definitions
               g   enumeration names
               m   class, struct, or union members
               n   namespaces
               p   function prototypes and declarations [off]
               s   structure names
               t   typedefs
               u   union names
               v   variable definitions
               x   extern and forward variable declarations [off]


            In  addition  to  the above flags, the following one-
            letter modifiers are accepted:


               A   Record the access of each member into the  tag
                   file.  This  information  is recorded using an
                   extension flag labeled "access".
               C   Include an extra,  class-qualified  tag  entry
                   for each class member in the form "class::mem-
                   ber".  This  allows  locating  class-qualified
                   tags  (e.g.  ":tag  class::member"  in vi(1)).
                   This is disabled by default because this could
                   potentially  more  than double the size of the
                   tag file.




       --eiffel-types=types
            Specifies a list of Eiffel language tag types  to  be
            included  in  the  output.   See  --c-types  for  the



Darren Hiebert         Version 4.0.1                      9





CTAGS(1)                                                 CTAGS(1)


            definition of the format of types. Tags for the  fol-
            lowing   Eiffel  language  constructs  are  supported
            (types are enabled by default except as noted):


               c   classes
               f   features
               l   local entities [off]


            In addition to the above flags,  the  following  one-
            letter modifiers are accepted:


               C   Include  an  extra,  class-qualified tag entry
                   for each class member in the form  "class.mem-
                   ber".  This  allows  locating  class-qualified
                   tags (e.g. ":tag class.member" in vi(1)). This
                   is  disabled  by  default  because  this could
                   potentially more than double the size  of  the
                   tag file.


       --etags-include=file
            Include  a  reference  to  file in the tag file. This
            option may be specified as  many  times  as  desired.
            This  supports  Emacs'  capability  to use a tag file
            which "includes" other tag files. [Used only with -e]


       --excmd=type
            Determines the type of EX command used to locate tags
            in the source file.  [Ignored with -e]


            The valid values for type (either the entire word  or
            the first letter is accepted) are:

            number   Use  only  line  numbers in the tag file for
                     locating tags. This has four advantages:
                     1.  Significantly reduces the  size  of  the
                         resulting tag file.
                     2.  Eliminates failures to find tags because
                         the line defining the tag  has  changed,
                         causing  the pattern match to fail (note
                         that some editors, such as vim, are able
                         to recover in many such instances).
                     3.  Eliminates  finding  identical matching,
                         but incorrect, source lines  (see  BUGS,
                         below).
                     4.  Retains separate entries in the tag file
                         for lines which are  identical  in  con-
                         tent. In pattern mode, duplicate entries
                         are dropped because the search  patterns



Darren Hiebert         Version 4.0.1                     10





CTAGS(1)                                                 CTAGS(1)


                         they  generate are identical, making the
                         duplicate entries useless.

                     However, this  option  has  one  significant
                     drawback:  changes  to  the source files can
                     cause the line numbers recorded in  the  tag
                     file to no longer correspond to the lines in
                     the source file, causing jumps to some  tags
                     to miss the target definition by one or more
                     lines. Basically, this option is  best  used
                     when  the source code to which it is applied
                     is not subject  to  change.  Selecting  this
                     option  type causes the following options to
                     be ignored: -BF.


            pattern  Use  only  search  patterns  for  all  tags,
                     rather  than  the  line numbers usually used
                     for macro definitions. This has  the  advan-
                     tage  of  not referencing obsolete line num-
                     bers when lines have been added  or  removed
                     since the tag file was generated.


            mixed    In  this  mode,  patterns are generally used
                     with a few exceptions. For C,  line  numbers
                     are used for macro definition tags. This was
                     the default format generated by the original
                     ctags  and  is,  therefore,  retained as the
                     default for this option. For  Fortran,  line
                     numbers  are  used for common blocks because
                     their corresponding source lines are  gener-
                     ally identical, making pattern searches use-
                     less for finding all matches.


       --file-scope=yes|no
            Indicates whether tags scoped only for a single  file
            (i.e.  tags  which cannot be seen outside of the file
            in which they are defined,  such  as  "static"  tags)
            should  be  included  in  the output. See also the -h
            option. This option is enabled by default.


       --file-tags=yes|no
            Indicates whether tags should be generated for source
            file names. This option is disabled by default.


       --filter=yes|no
            Causes  ctags  to  behave as a filter, reading source
            file names from standard  input  and  printing  their
            tags  to  standard output on a file-by-file basis. If
            --sorted is enabled, tags are sorted only within  the



Darren Hiebert         Version 4.0.1                     11





CTAGS(1)                                                 CTAGS(1)


            source file in which they are defined. File names are
            read from standard output in line-oriented input mode
            (see  note  for  -L option) and only after file names
            listed on the command line or from any file  supplied
            using the -L option. When this option is enabled, the
            options -f, -o, and --totals are ignored. This option
            is  quite  estoteric and is disabled by default. This
            option must appear before the first file name.


       --filter-terminator=string
            Specifies a string to print to standard  output  fol-
            lowing  the  tags  for each file name parsed when the
            --filter option is enabled. This may permit an appli-
            cation  reading the output of ctags to determine when
            the output for each file is finished.  Note  that  if
            the  file  name  read is a directory and --recurse is
            enabled, this string will be printed only one once at
            the  end  of  all  tags  found  for by descending the
            directory. This string will always be separated  from
            the  last  tag  line  for the file by its terminating
            newline.  This option is quite esoteric and is  empty
            by  default. This option must appear before the first
            file name.


       --format=level
            Change the format of the output tag  file.  Currently
            the  only  valid values for level are 1 or 2. Level 1
            specifies the original tag file format  and  level  2
            specifies  a new extended format containing extension
            flags (but in a manner which retains backward compat-
            ibility  with  original  vi(1)  implementations). The
            default level is 2. This option  must  appear  before
            the first file name. [Ignored with -e]


       --fortran-types=types
            Specifies  a list of Fortran language tag types to be
            included in the output.  See --c-types for the  defi-
            nition of the format of types. Tags for the following
            Fortran language constructs are supported (types  are
            enabled by default except as noted):


               b   block data
               c   common blocks
               e   entry points
               f   functions
               i   interfaces
               l   labels [off]
               m   modules
               n   namelists
               p   programs



Darren Hiebert         Version 4.0.1                     12





CTAGS(1)                                                 CTAGS(1)


               s   subroutines
               t   derived types


       --help
            Prints  to  standard output a detailed usage descrip-
            tion.


       --if0=yes|no
            Indicates a preference as to whether code  within  an
            "#if  0"  branch of a preprocessor conditional should
            be examined for non-macro tags (macro tags are always
            included). Because the intent of this construct is to
            disable code, the default value of  this  options  is
            no.  Note  that  this indicates a preference only and
            does not guarantee skipping code within  an  "#if  0"
            branch,  since the fall-back algorithm used to gener-
            ate tags when preprocessor conditionals are too  com-
            plex  follows  all  branches  of  a conditional. This
            option is disabled by default.


       --java-types=types
            Specifies a list of Java language  tag  types  to  be
            included  in the output.  See --c-types for the defi-
            nition of the format of types. Tags for the following
            Java  language  constructs  are  supported  (all  are
            enabled by default):


               c   classes
               f   fields
               i   interfaces
               m   methods
               p   packages


            In addition to the above flags,  the  following  one-
            letter modifiers are accepted:


               A   Record  the  access of each field into the tag
                   file. This information is  recorded  using  an
                   extension flag labeled "access".
               C   Include  an  extra,  class-qualified tag entry
                   for each class member in the form  "class.mem-
                   ber".  This  allows  locating  class-qualified
                   tags (e.g. ":tag class.member" in vi(1)). This
                   is  disabled  by  default  because  this could
                   potentially more than double the size  of  the
                   tag file.





Darren Hiebert         Version 4.0.1                     13





CTAGS(1)                                                 CTAGS(1)


       --kind-long=yes|no
            Specifies  whether the identifier for the kind of the
            tag listed in extension flags of the tag  file  is  a
            verbose  name or a single letter. See the description
            of kind in EXTENSION FLAGS, below. When enabled, this
            will increase the size of the output by an average of
            about 5 characters per line  or,  roughly,  5%.  This
            option must appear before the first file name.


       --lang[uage]=language
            By  default, ctags automatically selects the language
            of a source file, ignoring those files whose language
            cannot  be determined (see SOURCE FILES, above). This
            option forces the specified language to be  used  for
            every  supplied file instead of automatically select-
            ing the language based upon its extension. The recog-
            nized  languages  are  asm, awk, beta, c, c++, cobol,
            eiffel, fortran, java, lisp,  perl,  python,  scheme,
            sh,  tcl,  and  vim.   In addition, the special value
            auto indicates that the language should be  automati-
            cally selected. The default is auto.


       --langmap=map(s)
            Changes  the  mapping  between  file  extensions  and
            source languages  (see  SOURCE  FILES,  above).  Each
            comma-separated  map  consists of the source language
            name, a colon, and a list of extensions separated  by
            periods.   If  the first character in a map is a plus
            sign,  then  the  extensions  in  that  map  will  be
            appended to the current map for that language; other-
            wise, the map will replace the current map. For exam-
            ple,  to  specify  that only files with extensions of
            .c, .ec, and .xs are to  be  treated  as  C  language
            files,  use  "--langmap=c:.c.ec.xs".  To also specify
            that files with extensions of .j are to be treated as
            Java           language           files,          use
            "--langmap=c:.c.ec.xs,java:+.j".  To  indicate  files
            having  no  extension, use a period not followed by a
            non-period character (e.g.  ".",  "..x",  ".x.").  To
            clear  the  mapping  for  a particular language (thus
            preventing generation of  tags  for  that  language),
            specify     an    empty    extension    list    (e.g.
            "--langmap=Fortran:"). To restore  the  default  lan-
            guage  mappings for all a particular language, supply
            the keyword "default" for the  mapping.   To  specify
            restore  the  default  language mappings for all lan-
            guages, specify --langmap=default.


       --license
            Prints a summary of the software license to  standard
            output.



Darren Hiebert         Version 4.0.1                     14





CTAGS(1)                                                 CTAGS(1)


       --line-directives=yes|no
            Specifies whether "#line" directives should be recog-
            nized. These are present in the output of  preproces-
            sors  and  contain  the line number, and possibly the
            file name, of the original source file(s) from  which
            the  preprocessor  output  file  was  generated. When
            enabled, this option will cause ctags to generate tag
            entries  marked  with the file names and line numbers
            of their locations original source  file(s),  instead
            of their actual locations in the preprocessor output.
            The actual file names placed into the tag  file  will
            have  the same leading path components as the prepro-
            cessor output file, since  it  is  assumed  that  the
            original  source  files  are  located relative to the
            preprocessor output  file  (unless,  of  course,  the
            #line  directive  specifies  an  absolute path). This
            option is off by default. Note: This option is gener-
            ally   only   useful  when  used  together  with  the
            --excmd=number (-n) option. Also, you may have to use
            either  the  --lang or --langmap option if the exten-
            sion of the preprocessor output file is not known  to
            ctags.


       --links=yes|no
            Indicates  whether  symbolic  links  (if  suppported)
            should be followed. When disabled, symbolic links are
            ignored. This option is on by default.


       --options=file
            Read additional options from file.


       --recurse=yes|no
            Recurse  into  directories encountered in the list of
            supplied files. If the  list  of  supplied  files  is
            empty  and  no  file  list  is  specified with the -L
            option, then the  current  directory  (i.e.  ".")  is
            assumed.   On  Unix,  directories  named  "SCCS"  are
            skipped, because files in these directories  are  not
            source  code, even though they have the same names as
            the source code to  which  they  relate.  Directories
            named  "EIFGEN"  are  skipped,  because these contain
            Eiffel compiler-generated C files. Also on Unix, sym-
            bolic  links  are  followed.  If you don't like these
            behaviors, either explicitly  specify  the  files  or
            pipe  the  output  of find(1) into ctags -L- instead.
            Note: This option is not supported on  all  platforms
            at present.


       --sort=yes|no
            Indicates  whether  the  tag file should be sorted on



Darren Hiebert         Version 4.0.1                     15





CTAGS(1)                                                 CTAGS(1)


            the tag name (default is yes). Note that the original
            vi(1)  requires  sorted  tags.  This  option is on by
            default. This option must  appear  before  the  first
            file name.  [Ignored with -e]


       --totals=yes|no
            Prints statistics about the source files read and the
            tag file written during  the  current  invocation  of
            ctags.  This  option  is off by default.  This option
            must appear before the first file name.


       --verbose=yes|no
            Enable verbose mode. This prints out  information  on
            option processing and a brief message describing what
            action is being taken for  each  file  considered  by
            ctags.  Normally,  ctags  does  not read command line
            arguments until after options are read from the  con-
            figuration  files  (see  FILES,  below) and the CTAGS
            environment variable. However, if this option is  the
            first  argument  on  the  command  line, it will take
            effect  before  any  options  are  read  from   these
            sources.


       --version
            Prints  a  version  identifier  for ctags to standard
            output. This is  guaranteed  to  always  contain  the
            string "Exuberant Ctags".



OPERATIONAL DETAILS
       For  every  one of the qualified objects which are discov-
       ered in the source files supplied  to  ctags,  a  separate
       line  is  added to the tag file, each looking like this in
       the most general case:


           tag_name    file_name    ex_cmd;"    xflags


       The fields and separators of these lines are specified  as
       follows:


           1.  tag name (a C language identifier)
           2.  a single tab character
           3.  the  name  of the file in which the object associ-
               ated with the tag is located
           4.  a single tab character
           5.  an EX command to locate the tag within  the  file;
               generally  a  search  pattern (either /pattern/ or



Darren Hiebert         Version 4.0.1                     16





CTAGS(1)                                                 CTAGS(1)


               ?pattern?) or line number (see --excmd). Tag  file
               format  2  (see  --format) extends this EX command
               under certain circumstances to include  a  set  of
               extension   flags  (see  EXTENSION  FLAGS,  below)
               embedded in an EX comment immediately appended  to
               the EX command, which leaves it backwards compati-
               ble with original vi(1) implementations.


       A few special tags are  written  into  the  tag  file  for
       internal  purposes.  These tags are composed in such a way
       that they always sort to the top of the file.   Therefore,
       the  first  two  characters of these tags are used a magic
       number to detect a tag file for  purposes  of  determining
       whether  a valid tag file is being overwritten rather than
       a source file.


       When this program is invoked by the name  etags,  or  with
       the  -e  option,  the output file is in a different format
       that is used by emacs(1).


       Note that the name of each source file will be recorded in
       the  tag  file  exactly as it appears on the command line.
       Therefore, if the path you specified on the  command  line
       was  relative  to some directory, then it will be recorded
       in that same manner in the tag file.


       This version of ctags imposes no formatting  requirements.
       Other  versions  of ctags tended to rely upon certain for-
       matting assumptions in order to  help  it  resolve  coding
       dilemmas caused by preprocessor conditionals.


       In general, ctags tries to be smart about conditional pre-
       processor directives. If  a  preprocessor  conditional  is
       encountered  within a statement which defines a tag, ctags
       follows only the first branch of that conditional  (except
       in  the  special case of "#if 0", in which case it follows
       only the last branch). The reason for this is that failing
       to  pursue only one branch can result in ambiguous syntax,
       as in the following example:


              #ifdef TWO_ALTERNATIVES
              struct {
              #else
              union {
              #endif
                  short a;
                  long b;
              }



Darren Hiebert         Version 4.0.1                     17





CTAGS(1)                                                 CTAGS(1)


       Both branches cannot be followed, or braces become  unbal-
       anced  and ctags would be unable to make sense of the syn-
       tax.


       If the application of this  heuristic  fails  to  properly
       parse  a  file, generally due to complicated and inconsis-
       tent pairing within the conditionals, ctags will retry the
       file  using  a  different  heuristic which does not selec-
       tively  follow  conditional  preprocessor  branches,   but
       instead  falls  back to relying upon a closing brace ("}")
       in column 1 as indicating the end  of  a  block  once  any
       brace  imbalance  results from following a #if conditional
       branch.


       Ctags will also try to specially  handle  arguments  lists
       enclosed  in double sets of parentheses in order to accept
       the following conditional construct:


              extern void foo __ARGS((int one, char two));


       Any name immediately preceding the "((" will be  automati-
       cally ignored and the previous name will be used.


       C++  operator  definitions are specially handled. In order
       for consistency with all types  of  operators  (overloaded
       and  conversion),  the  operator name in the tag file will
       always be preceded by the string "operator " (i.e. even if
       the  actual  operator  definition  was  written as "opera-
       tor<<").


       After creating or appending to the tag file, it is  sorted
       by the tag name, removing identical tag lines.


       Note  that the path recorded for filenames in the tag file
       and utilized by the editor to search for tags are  identi-
       cal  to  the  paths  specified  for file(s) on the command
       line. This means the if you want the paths for files to be
       relative to some directory, you must invoke ctags with the
       same pathnames for file(s) (this can  be  overridden  with
       -p).



EXTENSION FLAGS
       Extension flags are tab-separated key-value pairs appended
       to the end of the EX command as a  comment,  as  described
       above  in  OPERATIONAL  DETAILS.   These  key  value pairs



Darren Hiebert         Version 4.0.1                     18





CTAGS(1)                                                 CTAGS(1)


       appear in the general form "key:value".  The possible keys
       and the meaning of their values are as follows:


       access      Indicates the visibility of this class member,
                   where value is specific to the language.


       class       Indicates that this tag is  a  member  of  the
                   class whose name is given by value.


       enum        Indicates  that  this  tag  is a member of the
                   enumeration whose name is given by value.


       file        Indicates that  the  tag  has  a  file-limited
                   scope  (i.e. is static to the file).  This key
                   has no corresponding value.


       kind        Indicates the type of the tag.  Its  value  is
                   either  one  of  the  corresponding one-letter
                   flags    described    under    the     various
                   --<lang>-types  options above, or a full name,
                   depending upon the value  of  the  --kind-long
                   option.  Alternatively,  this key may be omit-
                   ted, with only its value present (i.e. a field
                   without a ':' defaults to the kind key).


       implementation
                   When  present, this indicates a limited imple-
                   mentation (abstract vs. concrete) of a routine
                   or  class, where value is specific to the lan-
                   guage ("virtual" or "pure  virtual"  for  C++;
                   "abstract" for Java).


       inherits    When present, value. is a comma-separated list
                   of classes from which this  class  is  derived
                   (i.e. inherits from).


       interface   Indicates  that  this  tag  is a member of the
                   interface whose name is given by value.


       namespace   Indicates that this tag is  a  member  of  the
                   namespace whose name is given by value.


       struct      Indicates  that  this  tag  is a member of the
                   structure whose name is given by value.



Darren Hiebert         Version 4.0.1                     19





CTAGS(1)                                                 CTAGS(1)


       union       Indicates that this tag is  a  member  of  the
                   union whose name is given by value.



ENVIRONMENT VARIABLES
       CTAGS   If  this  enviroment  variable  exists, it will be
               expected to contain a set of default options which
               are  read  when ctags starts, after the configura-
               tion files listed in FILES, below, are  read,  but
               before  any command line options are read. Options
               appearing  on  the  command  line  will   override
               options  specified in this file. Only options will
               be read from this file.


       ETAGS   Similar to the CTAGS variable  above,  this  vari-
               able, if found, will be read when etags starts. If
               this variable is not found, etags will try to  use
               CTAGS instead.


       TMPDIR  On  Unix-like  hosts where mkstemp() is available,
               the value of this variable specifies the directory
               in  which  to  place  temporary files. This can be
               useful if the size of a temporary file becomes too
               large  to fit on the partition holding the default
               temporary directory defined at  compilation  time.
               ctags  creates  temporary files only if either (1)
               an emacs-style tag file is  being  generated,  (2)
               the  tag file is being sent to standard output, or
               (3) the program was compiled to  use  an  internal
               sort  algorithm  to  sort the tag files instead of
               the the sort utility of the operating  system.  If
               the  sort utility of the operating system is being
               used, it  will  generally  observe  this  variable
               also.  Note  that if ctags is setuid, the value of
               TMPDIR will be ignored.


HOW TO USE WITH VI
       Vi will, by default, expect a tag file by the name  "tags"
       in  the current directory. Once the tag file is built, the
       following commands exercise the tag indexing feature:

       vi -t tag   Start vi and position the cursor at  the  file
                   and line where "tag" is defined.

       Control-]   Find the tag under the cursor.

       :ta tag     Find a tag.

       Control-T   Return to previous location before jump to tag
                   (not widely implemented).



Darren Hiebert         Version 4.0.1                     20





CTAGS(1)                                                 CTAGS(1)


HOW TO USE WITH GNU EMACS
       Emacs will, by default, expect a  tag  file  by  the  name
       "TAGS"  in  the  current  directory.  Once the tag file is
       built, the following commands exercise  the  tag  indexing
       feature:

       Meta-x visit-tags-table
                   Visit a TAGS file.

       Meta-.      Find  a definition for a tag.  The default tag
                   is the identifier under the cursor.  There  is
                   name completion in the minibuffer; typing "foo
                   TAB" completes the  identifier  starting  with
                   `foo'  (`foobar',  for  example)  or lists the
                   alternatives.

       Meta-,      Find the next definition for the  tag.   Exact
                   matches  are  found first, followed by fuzzier
                   matches.


       For more commands, see the Tags topic in  the  Emacs  info
       tree.



BUGS (CAVEATS)
       Ctags has as many options as ls(1).


       Because  ctags  is  neither a preprocessor nor a compiler,
       use of preprocessor macros  can  fool  ctags  into  either
       missing  tags or improperly generating inappropriate tags.
       Although ctags has been designed to handle certain  common
       cases,  this is the single biggest cause of reported prob-
       lems. In particular, the use  of  preprocessor  constructs
       which  alter  the  textual syntax of C can fool ctags. You
       can work around many such problems by using the -I option.


       When  parsing  a  C++  member  function  definition  (e.g.
       "className::function"), ctags cannot determine whether the
       scope  specifier  is a class name or a namespace specifier
       and always lists it as a class name in the  scope  portion
       of the extension flags.


       White  space  is treated as a separator for file names and
       options read from  list  files,  specified  using  the  -L
       option,  and  in filter mode (specified using the --filter
       option). Therefore, it is not currently possible to supply
       file  names  or  other  options  containing embedded white
       space (spaces, etc.) through these options.




Darren Hiebert         Version 4.0.1                     21





CTAGS(1)                                                 CTAGS(1)


       Legacy C source code which uses C++ reserved  keywords  as
       variable  or  parameter  names  (e.g.  "class", etc.) in a
       header file may fail to have correct  tags  generated  for
       the  objects  using them. In order to properly handle such
       code, use the --lang option.


       Note that when ctags generates uses patterns for  locating
       tags  (see  the  --excmd  option), it is entirely possible
       that the wrong line may be found by your editor  if  there
       exists  another source line which is identical to the line
       containing the tag.  The  following  example  demonstrates
       this condition:


              int variable;

              /* ... */
              void foo(variable)
              int variable;
              {
                  /* ... */
              }


       Depending  upon which editor you use and where in the code
       you happen to be, it is possible that the  search  pattern
       may locate the local parameter declaration in foo() before
       it finds the actual global variable definition, since  the
       lines (and therefore their search patterns are identical).
       This can be avoided by use of the --excmd=n option.



FILES
       /etc/ctags.conf
       /usr/local/etc/ctags.conf
       $HOME/.ctags
       .ctags
                 If any of these configuration files exist,  each
                 will  be  expected  to  contain a set of default
                 options which are read in the order listed  when
                 ctags  starts,  but  before the CTAGS enviroment
                 variable is read or any command line options are
                 read.  This  makes  it  possible to set up site-
                 wide, personal or project-level defaults. It  is
                 possible  to compile ctags to read an additional
                 configuration    file     immediately     before
                 $HOME/.ctags,  which  will  be  indicated if the
                 output produced by the  --version  option  lists
                 the  "custom-conf" feature. Options appearing in
                 the CTAGS enviroment variable or on the  command
                 line  will  override  options specified in these
                 files. Only options  will  be  read  from  these



Darren Hiebert         Version 4.0.1                     22





CTAGS(1)                                                 CTAGS(1)


                 files.


       tags      The default tag file created by ctags.

       TAGS      The default tag file created by etags.


SEE ALSO
       The official Exuberant Ctags web site at:


           http://darren.hiebert.com/ctags/index.html


       Also  ex(1),  vi(1), elvis, or, better yet, vim, the offi-
       cial editor of ctags. For more information on vim, see the
       VIM Pages web site at:


           http://www.vim.org/



AUTHOR
       Darren Hiebert <darren@hiebert.com>, <darren@hiwaay.net>
       http://darren.hiebert.com/



MOTIVATION
       "Think  ye at all times of rendering some service to every
       member of the human race."


       "All effort and exertion put forth by man from  the  full-
       ness  of  his  heart  is worship, if it is prompted by the
       highest motives and the will to do service to humanity."


                 -- From the Baha'i Writings



CREDITS
       This version of ctags  was  originally  derived  from  and
       inspired  by  the ctags program by Steve Kirkendall <kirk-
       enda@cs.pdx.edu>  that  comes  with  the  Elvis  vi  clone
       (though virtually none of the original code remains).


       Credit  is  also  due  Bram  Moolenaar <Bram@vim.org>, the
       author of vim, who has devoted so much  of  his  time  and
       energy  both  to  developing  the  editor  as a service to



Darren Hiebert         Version 4.0.1                     23





CTAGS(1)                                                 CTAGS(1)


       others, and to helping the orphans of Uganda.


       The section entitled "HOW  TO  USE  WITH  GNU  EMACS"  was
       shamelessly stolen from the man page for GNU etags.




















































Darren Hiebert         Version 4.0.1                     24


