// Locale support -*- C++ -*-

// Copyright (C) 1997-1999, 2000 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 22.1  Locales
// Uses OS/2 Unicode API for best locale support
//

extern "C" {
#define INCL_DOS
#include <os2.h>
#include <unidef.h>
#include <uconv.h>

#include <malloc.h>
}

extern "C" int write (int, const char*, int);

  /* Trick: since we have no control over the destructor of the object,
   * and also for performance reasons we will use a global variable to
   * store the precomputed ctype tables. This also speeds up the
   * constructor since we will have to precompute the table just at
   * the program startup.
   */

  static bool __ctype_data_inited = false;
  static struct __ctype_data
  {
    ctype_base::mask ctable [256];
    unsigned char toupper [256], tolower [256];

    void Initialize ()
    {
      if (__ctype_data_inited)
        return;

      __ctype_data_inited = true;

      /* First of all, we translate all 256 possible characters
       * from the codepage of current process to Unicode.
       */

      ULONG cp [3], cplen;
      if (DosQueryCp (sizeof (cp), cp, &cplen))
        goto locale_error;

      UniChar cpnamebuff [16];
      if (UniMapCpToUcsCp (cp [0], cpnamebuff, sizeof (cpnamebuff) / sizeof (UniChar)))
        goto locale_error;

      UconvObject uconv_obj;
      if (UniCreateUconvObject (cpnamebuff, &uconv_obj))
        goto locale_error;

      /* Convert characters to unicode, one by one. We can't do it in one shot
       * because some characters may be MBCS prefix bytes, and they potentially
       * can "eat" the next following symbol, shifting entire output array by one
       */

      int i;
      UniChar ucs [256];
      for (i = 0; i < 256; i++)
        {
          size_t in_left = 1, out_left = 1, nonid;
          void *inbuf = &i;
          UniChar uc;
          UniChar *outbuf = &uc;
          if (UniUconvToUcs (uconv_obj, &inbuf, &in_left, &outbuf, &out_left, &nonid))
            uc = i;
          ucs [i] = uc;

          uc = UniToupper (ucs [i]);
          if (UniUconvToUcs (uconv_obj, &inbuf, &in_left, &outbuf, &out_left, &nonid))
            uc = i;
          toupper [i] = uc;

          uc = UniTolower (ucs [i]);
          if (UniUconvToUcs (uconv_obj, &inbuf, &in_left, &outbuf, &out_left, &nonid))
            uc = i;
          tolower [i] = uc;
        }

      UniFreeUconvObject (uconv_obj);

      /* Now determine the characteristics of these 256 characters.
       */
      LocaleObject locale_obj;
      if (UniCreateLocaleObject (UNI_TOKEN_POINTER, NULL, &locale_obj))
        {
locale_error:
#define MESSAGE "FATAL: Error initializing locale"
          write (1, MESSAGE, sizeof (MESSAGE) - 1);
#undef MESSAGE
          abort ();
        }

      /* Now query all the Unicode characters we got for their attributes
       */
      for (i = 0; i < 256; i++)
      {
        UniChar uc = ucs [i];
        unsigned short m = 0;
        if (UniQueryAlnum (locale_obj, uc))
          m |= __ctype_ALNUM;
        if (UniQueryAlpha (locale_obj, uc))
          m |= __ctype_ALPHA;
        if (UniQueryCntrl (locale_obj, uc))
          m |= __ctype_CNTRL;
        if (UniQueryDigit (locale_obj, uc))
          m |= __ctype_DIGIT;
        if (UniQueryGraph (locale_obj, uc))
          m |= __ctype_GRAPH;
        if (UniQueryLower (locale_obj, uc))
          m |= __ctype_LOWER;
        if (UniQueryPrint (locale_obj, uc))
          m |= __ctype_PRINT;
        if (UniQueryPunct (locale_obj, uc))
          m |= __ctype_PUNCT;
        if (UniQuerySpace (locale_obj, uc))
          m |= __ctype_SPACE;
        if (UniQueryUpper (locale_obj, uc))
          m |= __ctype_UPPER;
        if (UniQueryXdigit (locale_obj, uc))
          m |= __ctype_XDIGIT;
        ctable [i] = m;
      }

      UniFreeLocaleObject (locale_obj);
    }
  } __ctype_data_inst;

  ctype<char>::ctype(const mask* __table, bool __del, size_t __refs) 
    : __ctype_abstract_base<char>(__refs),
      _M_del(__table != 0 && __del),
      _M_toupper (__ctype_data_inst.toupper),
      _M_tolower (__ctype_data_inst.tolower),
      _M_ctable (__ctype_data_inst.ctable),
      _M_table ((__table == 0) ? _M_ctable : __table)
  {
    __ctype_data_inst.Initialize ();
  }

  char
  ctype<char>::do_toupper(char __c) const
  { return _M_toupper[(unsigned char)__c]; }

  const char*
  ctype<char>::do_toupper(char* __low, const char* __high) const
  {
    while (__low < __high)
      {
	*__low = _M_toupper[*(unsigned char *)__low];
	++__low;
      }
    return __high;
  }

  char
  ctype<char>::do_tolower(char __c) const
  { return _M_tolower[(unsigned char)__c]; }

  const char* 
  ctype<char>::do_tolower(char* __low, const char* __high) const
  {
    while (__low < __high)
      {
	*__low = _M_tolower[*(unsigned char *)__low];
	++__low;
      }
    return __high;
  }
