        Free headers and libraries for the Win32 API

        Written by Anders Norlander
        Send bug reports and questions to anorland@hem2.passagen.se
        URL: http://www.acc.umu.se/~anorland/gnu-win32/

* License

  You are free to use, modify and copy this package. No restrictions
  are imposed on programs or object files compiled with this library.

  You may distribute this library as part of another package or as a
  modified package if and only if you do *not* restrict the usage of
  the portions consisting of this (optionally modified) library.

  If distributed as part of another package, please notify the author
  of what you are going to do.  If distributed as a modified package,
  this README file *must* be included (it may be renamed).

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

* What is it?

  This is a free set of headers and import libraries for the Win32 API.
  The library differs from the GNU Windows32 library in that I have
  tried to use a file structure that resembles the MS one.  I don't
  like having *all* definitions in one single header as in the GNU
  Windows32 library, I wanted a clean separation between different
  parts of the API.

  The library is not yet finished. See the files Notes and TODO for
  more information.

* Size does matter

  Since the WIN32 API is severely bloated (as most MS products seem to
  be) the headers are designed to be as compact as possible, while
  still being readable, in order to minimize parsing time.

  The convention is to omit parameter names for function prototypes,
  no excessive white space. Struct/union members are indented with tab
  characters to make them readable. Comment only when necessary.

  If you are contributing a patch please follow the above mentioned
  convention. Make sure your editor does not convert tabs to spaces.

* What do I need to use it?

  The library is intended for use with egcs 1.1 or later but it is
  possible to use with some other tools as well (although it is not
  very useful). LCC-Win32, MSVC and Borland C++ 5.01 or higher should
  work.  Note that this is NOT extensively tested in any way. Import
  libraries are for egcs only.

  The library requires egcs 1.1 or later, since the `#pragma pack'
  command is used. Mumit Khan distributes egcs binaries at
  `http://www.xraylith.wisc.edu/~khan/software/gnu-win32/'.

  If you are going to use C++ COM objects, you will need a version of
  egcs that recognizes the `comobject' attribute. Antonio Mendes de
  Oliveira Neto has a prebuilt version at
  `http://li.facens.br/EGCS-WIN32/english/index.html'. Note that
  this is very experimental. If you want to use COM objects in C++
  but with C interfaces you must define CINTERFACE.
  
* Installing the prebuilt distribution

  Just unpack the archive in the appropriate directory, if you are
  using gcc or egcs for win32 this is the i[345]86-cygwin(32) or
  i[345]86-mingw32 directory in the compiler tree.

* Installing and building the source distribution

  First of all, you will need GNU Make, GNU Binutils for win32 and egcs
  installed in your system. You will need a recent version of dlltool
  to build the import libraries.
  
  Type `make' to build the import libraries and test the headers.
  'make install' will install the library. 'make install prefix=<dir>'
  will install the library into <dir>.
