/* smutex.c -  replaces smutex.c in the emx library

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include <emx/syscalls.h>
#include <sys/builtin.h>
#include <sys/smutex.h>

#define WIN32_LEAN_AND_MEAN
#include <wingnuc.h>
#include <windows.h>

/****************************************************************************/
/*          REPLACE \emx\src\lib\process\fmutex.c                           */
/****************************************************************************/

void __rsxntfix_smutex_request_internal (volatile _smutex *sem)
{
  do
    {
      Sleep (1);
    } while (__cxchg (sem, 1) != 0);
}
