/* io.c - map io calls to rsxio dll

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#ifdef USE_WINDOWS_HEADER
#include <windows.h>
#else
#define FALSE 0
#define TRUE 1
#define SW_SHOWDEFAULT 10
#define WINAPI __attribute__((stdcall))
typedef unsigned int UINT;
typedef unsigned int HWND;
typedef int BOOL;
typedef char *LPSTR;
typedef void *HANDLE;
typedef void *HINSTANCE;
typedef void WINAPI (*FARPROC)(void);
int WINAPI SetWindowTextA(HWND, char *);
int WINAPI DestroyWindow(HWND);
HANDLE WINAPI GetModuleHandleA(char *);
#endif

#include <emx/syscalls.h>
#include <emx/io.h>
#include <stdlib.h>
#include <fcntl.h>
#include <setjmp.h>
#include <sys/ioctl.h>
#include <rsxioapp.h>
#include "rsxio.h"

extern int _files[];

static jmp_buf  JmpBuf;
static HWND     hWnd;
static BOOL     window_closed = FALSE;

int __read(int handle, void *buf, size_t nbyte)
{
    extern int __read_old(int handle, void *buf, size_t nbyte);

    if ((_files[handle] & F_DEV) && ((_files[handle] & O_ACCMODE) == O_RDONLY))
        return RSXIO_Read(hWnd, buf, nbyte);
    else
        return __read_old(handle, buf, nbyte);
}

int __write(int handle, __const__ void *buf, size_t nbyte)
{
    extern int __write_old(int handle, __const__ void *buf, size_t nbyte);

    if ((_files[handle] & F_DEV) && ((_files[handle] & O_ACCMODE) == O_WRONLY))
        return RSXIO_Write(hWnd, (char *) buf, nbyte);
    else
        return __write_old(handle, buf, nbyte);
}

int __ioctl2(int handle, int request, int arg)
{
    extern int __ioctl2_old (int handle, int request, int arg);

    if (handle >= 0 && handle <= 2) {
        * (int *) arg = HT_DEV_CON;
        return 0;
    }
    else
        return __ioctl2_old (handle, request, arg);
}

int __read_kbd (int echo, int wait, int sig)
{
    return RSXIO_ReadKbd(hWnd, echo, wait, sig);
}

static void exit_func()
{
    if (window_closed == FALSE) {           // if exit called
        if (!rsxio_window_close) {
            SetWindowTextA(hWnd, "terminated!");
            RSXIO_WaitClose(hWnd);          // inactiv window
        }
        else
            DestroyWindow(hWnd);            // close window
    }
}

static void CloseFunc(void)
{
    window_closed = TRUE;
    longjmp(JmpBuf, 1);
}

int WINAPI WinMain(void) /* we need GUI */
{
    return 1;
}
#ifndef __EMX__
__asm__(".stabs \"_WinMain\",5,0,0,_WinMain");
#endif

int main(int argc, char **argv, char **env)
{
    hWnd = RSXIO_Register(GetModuleHandleA(NULL), rsxio_window_title, SW_SHOWDEFAULT, CloseFunc);

    if (hWnd == 0)
        exit(1);

    atexit(exit_func);
    if (setjmp(JmpBuf) != 0)
        return 0;

    return rsxio_main(argc, argv, env);
}

