/ emx/syscalls.h (emx+gcc) -- Copyright (c) 1992-1993 by Eberhard Mattes

#define SYSCALL(x) movb $x,%ah;call ___syscall

#define ENOMEM     12
#define EINVAL     22

#define ALIGN      .align  2, 0x90

#if !defined (__MT__)

#define SYSRET0 \
        jb      1f ;\
        xorl    %eax, %eax ;\
        ret ;\
1:      movl    %eax, _errno ;\
        movl    $-1, %eax ;\
        ret

#define SYSRETEAX \
        jb      1f ;\
        ret ;\
1:      movl    %eax, _errno ;\
        movl    $-1, %eax ;\
        ret

#define RETERRNOECX \
        jecxz   1f ;\
        movl    %ecx, _errno ;\
        ALIGN ;\
1:      ret

#define SETERRNO(x) \
        movl    x, _errno


#else


#define SYSRET0 \
        jb      1f ;\
        xorl    %eax, %eax ;\
        ret ;\
1:      pushl   %eax ;\
        call    __errno_fun ;\
        popl    (%eax) ;\
        movl    $-1, %eax ;\
        ret

#define SYSRETEAX \
        jb      1f ;\
        ret ;\
1:      pushl   %eax ;\
        call    __errno_fun ;\
        popl    (%eax) ;\
        movl    $-1, %eax ;\
        ret

#define RETERRNOECX \
        jecxz   1f ;\
        pushl   %eax ;\
        pushl   %ecx ;\
        call    __errno_fun ;\
        popl    (%eax) ;\
        popl    %eax ;\
        ALIGN ;\
1:      ret

#define SETERRNO(x) \
        pushl   x ;\
        call    __errno_fun ;\
        popl    (%eax)

#endif
