/* checkcon.c - use by dup() to set handle 0-2 to console

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

void _rsxnt_check_console_handle(EMXPROCESS *p, int fd)
{
    DWORD device = 0xffffffff;

    if (p->bConsoleApp == FALSE || fd > 2)
        return;

    if (fd == 0)
        device = STD_INPUT_HANDLE;
    if (fd == 1)
        device = STD_OUTPUT_HANDLE;
    if (fd == 2)
        device = STD_ERROR_HANDLE;

    SetStdHandle(device, p->file[fd].f_handle);
}
