/* gmt2st.c - seconds since 1.1.1900 to win32 systemtime

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

/*
    Converts Unix time format to SYSTEMTIME
*/

#define leap(y) \
  ((y) % 4 != 0 ? 0 : (y) % 100 != 0 ? 1 : (y) % 400 != 0 ? 0 : 1)

void _rsxnt_gmt2st(unsigned long *t, SYSTEMTIME *st)
{
    static int const mon_len[12] =
    {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    unsigned long t0, t1;
    unsigned long q;

    t0 = *t;
    if (t0 == (unsigned long) (-1))
        return;

    st->wMilliseconds = 0;
    st->wSecond = (int) (t0 % 60L);
    q = t0 / 60L;
    t0 = q;
    st->wMinute = (int) (t0 % 60L);
    q = t0 / 60L;
    t0 = q;
    st->wHour = (int) (t0 % 24L);
    q = t0 / 24L;
    t0 = q;

    st->wDayOfWeek = (int) ((t0 + 4) % 7);
    st->wYear = 1970;
    for (;;) {
        t1 = (leap(st->wYear) ? 366 : 365);
        if (t1 > t0)
            break;
        t0 -= t1;
        ++st->wYear;
    }
    st->wMonth = 1;
    for (;;) {
        if (st->wMonth == 2)
            t1 = (leap(st->wYear) ? 29 : 28);
        else
            t1 = mon_len[st->wMonth-1];
        if (t1 > t0)
            break;
        t0 -= t1;
        ++st->wMonth;
    }
    st->wDay = (int) t0 + 1;
}

