/* kill.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

int __kill(int pid, int signo)
{
    EMXPROCESS *proc = _rsxnt_get_process_ptr();

    if (signo < 0 || signo >= NSIG)
        return _rsxnt_errno(EINVAL);

    if (!signo)
        return (proc->pid == pid) ? 0 : -1;

    if (pid < 0)
        pid = -pid;

    if (pid == proc->pid) {
        _rsxnt_send_signal(proc, signo);

#ifdef EMX_SYS_LIB
        _rsxnt_check_signals();
#endif
        return 0;
    } else if (pid == proc->debuggee.pid && signo == SIGKILL) {
        CONTEXT Context;
        FARPROC FarProc = GetProcAddress(
                GetModuleHandle("kernel32.dll"), "ExitProcess");
        int retv;

        /* set EIP to ExitProcess() */

        Context.ContextFlags = CONTEXT_CONTROL;
        GetThreadContext(proc->debuggee.hCurrentThread, &Context);
        Context.Eip = (DWORD) FarProc;
        Context.ContextFlags = CONTEXT_CONTROL;
        SetThreadContext(proc->debuggee.hCurrentThread, &Context);
        _rsxnt_do_ptrace(PTRACE_RESUME, pid, 0, 0, &retv);
        return retv;
    }
    else if (signo == SIGKILL) {
        int i;
        for (i = 0; i < MAX_CHILD; ++i)
            if (proc->childs[i].pid == pid)
                if (TerminateProcess(proc->childs[i].hProcess, 3) == FALSE)
                    return _rsxnt_errno(EACCES);
                else
                    return 0;
        return _rsxnt_errno(EINVAL);
    }
    else
        return _rsxnt_errno(EINVAL);
}
