/* pipe.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

int __pipe(int *two_handles, int size)
{
    static SECURITY_ATTRIBUTES defsec =
        { sizeof(SECURITY_ATTRIBUTES), NULL, TRUE };
    EMXPROCESS *proc = _rsxnt_get_process_ptr();
    int fdr, fdw;

    if ((fdr = _rsxnt_get_new_file(proc)) < 0)
        return _rsxnt_errno(EMFILE);

    fdw = _rsxnt_get_new_file(proc);
    if (fdw < 0) {
        proc->file[fdr].f_handle = INVALID_HANDLE_VALUE;
        return _rsxnt_errno(EMFILE);
    }

    if (CreatePipe(&proc->file[fdr].f_handle, &proc->file[fdw].f_handle,
                &defsec, size) == FALSE) {
        proc->file[fdr].f_handle = INVALID_HANDLE_VALUE;
        proc->file[fdw].f_handle = INVALID_HANDLE_VALUE;
        return _rsxnt_get_last_errno();
    }

    proc->file[fdr].f_mode = HT_UPIPE;
    proc->file[fdw].f_mode = HT_UPIPE;

    two_handles[0] = fdr;
    two_handles[1] = fdw;

    return 0;
}
