/* sigprocm.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

int __sigprocmask(int how, const sigset_t *set, sigset_t *oset)
{
    EMXPROCESS *proc = _rsxnt_get_process_ptr();
    sigset_t new_set, old_set = proc->sig_blocked;

    if (set) {
	new_set = *set;

	switch (how) {
	    case SIG_BLOCK:
		proc->sig_blocked |= new_set;
		break;
	    case SIG_UNBLOCK:
		proc->sig_blocked &= ~new_set;
		break;
	    case SIG_SETMASK:
		proc->sig_blocked = new_set;
		break;
	    default:
		return _rsxnt_errno(EINVAL);
	}
    }
    if (oset) {
	*oset = old_set;
    }
#ifdef EMX_SYS_LIB
	_rsxnt_check_signals();
#endif
    return 0;
}
