/* ttyname.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

int __ttyname (int fd, char *buf, size_t size)
{
    int ret;
    int type;

    if ((ret = __ioctl2(fd, FGETHTYPE, (int) &type)) < 0)
        return ret;

    if (type == FILE_TYPE_CHAR) {
        static char tty_console[] = "/dev/con";

        if (sizeof(tty_console) > size)
            return _rsxnt_errno(ENAMETOOLONG);
        memcpy(buf, tty_console, sizeof(tty_console));
        return 0;
    }
    else
        return _rsxnt_errno(ENODEV);
}
