/* _fd.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#include <emx/io.h>

/* See app/iodata.c. */

extern int _nfiles;
extern int _files[];
extern int _lookahead[];

/* Return pointer to flags word for the file descriptor HANDLE.
   Return NULL on error. */

int *_fd_flags (int handle)
{
  struct fdvec *p;

  if (handle < 0)
    return NULL;

  /* We want this case to be fast.  Note that _fdvec_head.n == _nfiles
     and _fdvec_head.flags == _files! */

  if (handle < _nfiles)
    return &_files[handle];

  handle -= _nfiles;
  p = _fdvec_head.next;
  while (p != NULL && handle >= p->n)
    {
      handle -= p->n;
      p = p->next;
    }
  if (p == NULL)
    return NULL;
  return &p->flags[handle];
}


/* Return pointer to lookahead word for the file descriptor HANDLE.
   Return NULL on error.

   Note: select() does this inline. */

int *_fd_lookahead (int handle)
{
  struct fdvec *p;

  if (handle < 0)
    return NULL;

  /* We want this case to be fast.  Note that _fdvec_head.n == _nfiles
     and _fdvec_head.lookahead == _lookahead! */

  if (handle < _nfiles)
    return &_lookahead[handle];

  handle -= _nfiles;
  p = _fdvec_head.next;
  while (p != NULL && handle >= p->n)
    {
      handle -= p->n;
      p = p->next;
    }
  if (p == NULL)
    return NULL;
  return &p->lookahead[handle];
}
