/*
** Module   :MMF.H
** Abstract :Memory Mapped Files Interface
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Wed  03/09/97       Created
*/

#ifndef  __MMF_H
#define  __MMF_H

/*
**  Constants
*/

#define MMF_READONLY            0x00000001  /* open file only for reading */
#define MMF_READWRITE           0x00000002  /* open file for read/write */

#define MMF_USEDENTRY           0x10000000  /* internal flag */
#define MMF_MAX                 32          /* maximal number of concurently
                                            /* active MMF areas */

typedef struct
{
    unsigned _fill_1;
    unsigned _fill_2;
}MMFINIT;

/*
**  Error codes
*/

#define ERROR_MMF_TOO_MANY_MMF_OPEN -1
#define ERROR_MMF_ZERO_FILE         -2
#define ERROR_MMF_INVALID_REGION    -3

/*
** OS/2-like API
*/

void DosInitMMF(void *MMFinitPtr);

int DosAllocMMF(char *file, void **ppdata, int opt);
int DosFreeMMF(void *);
int DosUpdateMMF(void *);

#endif /* __MMF_H */

