"""
    ZDataQueryKit Product
    ============= =======

A complete data query, collation, and reporting tool.

One of the main features of this product is that you do not need any
SQL programming skills - everything is visual!
"""
# $Id: __init__.py,v 1.1.1.1 2002/02/03 17:07:16 root Exp $
#
# $Log: __init__.py,v $
# Revision 1.1.1.1  2002/02/03 17:07:16  root
#
#
# Revision 1.5  2002/01/21 00:58:09  adrian
# Rebased all queries and datacombiner on the Aqueduct DA
# Added argument support
# Added Drill-Down support to ZReportTool
#
# Revision 1.4  2002/01/13 21:08:58  adrian
# Completed relational logic in ZDataCombiner.
# Fixed up compatibility bugs in combiner and report.
# Started online help pages.
#
# Revision 1.3  2002/01/02 07:55:37  adrian
# Added initial support for Visual ODBC Client
#
# Revision 1.2  2001/10/21 15:03:36  adrian
# no message
#
#
__version__ = '$Revision: 1.1.1.1 $'[11:-2]

import ZVisualQuery
import ZDataCombiner
import ZReportTool

#try:
if 1:
    import ZODBCClient
    import ZVisualODBCClient
#except:
#    pass

def initialize(context):
    context.registerClass(
        ZVisualQuery.ZVisualQuery,
        meta_type='Z Visual Query',
        icon='www/ZVisualQuery.gif',
        permission='Add Z Visual Queries',
        constructors=(
            ZVisualQuery.manage_addZVisualQueryForm,
            ZVisualQuery.manage_addZVisualQuery
        ),
    )
    context.registerClass(
        ZDataCombiner.ZDataCombiner,
        meta_type='Z Data Combiner',
        icon='www/ZDataCombiner.gif',
        permission='Add Z Data Combiners',
        constructors=(
            ZDataCombiner.manage_addZDataCombinerForm,
            ZDataCombiner.manage_addZDataCombiner
        ),
    )
    context.registerClass(
        ZReportTool.ZReportTool,
        meta_type='Z Report Tool',
        icon='www/ZReportTool.gif',
        permission='Add Z Report Tools',
        constructors=(
            ZReportTool.manage_addZReportToolForm,
            ZReportTool.manage_addZReportTool
        ),
    )
#    try:
    if 1:
        context.registerClass(
            ZODBCClient.ZODBCClient,
            meta_type = 'Z ODBC Client',
            icon = 'www/ZODBCClient.gif',
            permission = 'Add Z ODBC Clients',
            constructors=(
                ZODBCClient.manage_addZODBCClientForm,
                ZODBCClient.manage_addZODBCClient,
            ),
        )
        context.registerClass(
            ZVisualODBCClient.ZVisualODBCClient,
            meta_type='Z Visual ODBC Client',
            icon='www/ZVisualQuery.gif',
            permission='Add Z Visual ODBC Client',
            constructors=(
                ZVisualODBCClient.manage_addZVisualODBCClientForm,
                ZVisualODBCClient.manage_addZVisualODBCClient
            ),
        )
#    except:
#        pass
    context.registerHelpTitle('Z Data Query Kit')
    context.registerHelp()
