# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is MessageBoard version 1.0.
#
# The Initial Owner of the Original Code is European Environment
# Agency (EEA).  Portions created by Finsiel Romania are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Contributor(s):
# Cornel Nitu, Rares Vernica Finsiel Romania
#

from AccessControl import Permissions, ClassSecurityInfo
from OFS import SimpleItem, ObjectManager, FindSupport, PropertyManager
from Acquisition import Implicit
import Globals
from OFS import Folder
import Products
import DateTime
from os.path import join
from Message import manage_addMessageForm, manage_addMessage, addMessageForm, addMessage

manage_addMessageBoardForm=Globals.DTMLFile('dtml/MessageBoard_addForm', globals())

def manage_addMessageBoard(self, id, title='',description='', filesize=500000, mailhost='', integrated=0, REQUEST=None):
    """Add a new Meeting object"""
    ob=MessageBoard(id, title, description, filesize, mailhost, integrated)
    self._setObject(id, ob)
    object=self._getOb(id)

    indexfile = open(join(Globals.SOFTWARE_HOME ,'Products','MessageBoard','dtml','MessageBoardIndex.dtml'))
    content = indexfile.read()
    indexfile.close()

    object.manage_addDTMLMethod('index_html', title='Default View', file=content)

    if REQUEST is not None:
        return self.manage_main(self, REQUEST, update_menu=1)

def getMailHostList(self):
    """ List of mail hosts """
    try:
        list=self.superValues('Mail Host')
        newlist=[]
        for item in list:
            newlist.append(item.absolute_url(relative=1))
        return newlist
    except:
        return []

class MessageBoard(Implicit,Folder.Folder,PropertyManager.PropertyManager):
    """The Message class """

    meta_type       = "Message Board"
    product_name    = "MessageBoard"

    _properties=(
            {'id':'title',      'type':'string',    'mode':'w'},
            {'id':'description','type':'text',      'mode':'w'},
            {'id':'mailhost', 'type':'selection', 'mode':'w', 'select_variable':'getMailHostList'},
            {'id':'filesize', 'type':'int', 'mode':'w'},
    )

    manage_options = (ObjectManager.ObjectManager.manage_options[0],) + (
        PropertyManager.PropertyManager.manage_options + (
            {'label' : 'View',              'action' : 'index_html'},
            {'label' : 'Undo',              'action' : 'manage_undoForm'},
            ) +
            SimpleItem.SimpleItem.manage_options )

    # Create a SecurityInfo for this class. We will use this 
    # in the rest of our class definition to make security 
    # assertions.
    security = ClassSecurityInfo()

    security.setPermissionDefault('Change MessageBoard', ('Manager',))

    def __str__(self): return self.index_html()
    def __len__(self): return 1

    getMailHostList=getMailHostList

    security.declareProtected('Add Message','manage_addMessageForm')
    manage_addMessageForm=manage_addMessageForm
    manage_addMessage=manage_addMessage
    security.declareProtected('Add Message','addMessageForm')
    addMessageForm=addMessageForm
    addMessage=addMessage

    security.declareProtected('View management screens', 'all_meta_types')
    def all_meta_types(self):
        """return a filtered list of meta types"""

        f = lambda x: x['name'] in ('Message','DTML Method','Page Template','DTML Document')
        return filter(f, Products.meta_types)

    def __init__(self, id, title, description, filesize, mailhost, integrated):
        """ initialize the message board """
        self.id = id
        self.title =title
        self.description = description
        self.filesize = filesize
        self.mailhost = mailhost
        self.integrated = integrated

    def __setstate__(self, state):
        """update"""
        MessageBoard.inheritedAttribute('__setstate__')(self, state)
        if not hasattr(self, 'filesize'):
            self.filesize = 500000

    def messageTree(self, folder, depth=0, crt=0):
        """ returns the Message Tree """
        list=[]
        for object in folder.objectValues('Message'):
            list+=[{'crt':crt, 'depth':depth, 'object':object}]
            crt+=1
            newlist=self.messageTree(object, depth+2, crt)
            crt+=len(newlist)
            list+=newlist
        return list

    def getMPAbsolutePath(self):
        """Returns object's absolute path"""
        return self.absolute_url(0)

Globals.InitializeClass(MessageBoard)
