/*
This REXX program creates a certificate authority
(C) Z. Wagner -- Ice Bear Soft, 30 Jan 2000
-------------------------------------------------------------------------------
For usage see ..\etc\manual.html
-------------------------------------------------------------------------------
[20010528] "Michael Warmuth" <michael@warmuth.at> (C) Michael Warmuth:
   + Added:   Setting of RANDFILE environment variable, SETLOCAL/ENDLOCAL,
              replacement of exit with endit, and providing a rand file
              as I have no dought about how to create one (and I found one
              on my system).
   + Added:   Default openssl.cnf file and parameter "-config" to all
              openssl.exe calls to use this file.
   + Added:   Some comments.
   + Changed: Directory structure with bin, certs, doc, etc, and keys
              subdirectories and default paths changed accordingly.
   + Changed: Routine to create CRT file name.
-------------------------------------------------------------------------------
[20000130] "Z. Wagner" <wagner@mbox.cesnet.cz> (C) Ice Bear Soft:
   + Added:   Initial release
-------------------------------------------------------------------------------
*/

call setlocal
'@echo off'

/* Configuration section */
call value 'RANDFILE','..\etc\OpenSSL.rnd','OS2ENVIRONMENT'
conffile = '..\etc\OpenSSL.cnf'

/* Get argument */
parse arg key rest

/* Check syntax */
if rest\='' then do
  say 'Usage: ca <key>'
  say 'If key is not specified, ca.key is created'
  call endit 1
end

/* Set default value */
if key='' then key='ca.key'

/* Add path to keys directory if no directory specified */
if pos('\',key) = 0 then do
   key = '..\keys\' || key
end /* if */

/* Add extention '.key' if not present */
if translate(right(key,4)) \= '.KEY' then do
   key = key || '.key'
end /* if */

/* Create filename for CRT file */
crt = left(key,lastpos('.',key)) || 'crt'

say 'Create a RSA private key for your CA'
say '(will be Triple-DES encrypted and PEM formatted)'
say

'openssl genrsa -des3 -out' key '1024 -config' conffile

say 'Create a self-signed CA Certificate (X509 structure)'
say 'with the RSA key of the CA (output will be PEM formatted)'
say

'openssl req -new -x509 -days 365 -key' key '-out' crt '-config' conffile

call endit 0


/* Prepares exit and restores environment */
endit:

parse arg exitcode

if exitcode = '' then do
   exitcode = 1
end /* if */

call endlocal

exit exitcode
