/*
This REXX program creates a server key and certificate signing request
(C) Z. Wagner -- Ice Bear Soft, 30 Jan 2000
-------------------------------------------------------------------------------
For usage see ..\etc\manual.html
-------------------------------------------------------------------------------
[20010528] "Michael Warmuth" <michael@warmuth.at> (C) Michael Warmuth:
   + Added:   Setting of RANDFILE environment variable, SETLOCAL/ENDLOCAL,
              replacement of exit with endit, and providing a rand file
              as I have no dought about how to create one (and I found one
              on my system).
   + Added:   Default openssl.cnf file and parameter "-config" to all
              openssl.exe calls to use this file.
   + Added:   Some comments.
   + Changed: Directory structure with bin, certs, doc, etc, and keys
              subdirectories and default paths changed accordingly.
   + Changed: Routine to create CSR file name.
-------------------------------------------------------------------------------
[20000130] "Z. Wagner" <wagner@mbox.cesnet.cz> (C) Ice Bear Soft:
   + Added:   Initial release
-------------------------------------------------------------------------------
*/

call setlocal
'@echo off'

/* Configuration section */
call value 'RANDFILE','..\etc\OpenSSL.rnd','OS2ENVIRONMENT'
conffile = '..\etc\OpenSSL.cnf'

/* Get argument */
parse arg key rest

/* Check syntax */
if rest\='' then do
  say 'Usage: cert <key>'
  say 'If key is not specified, server.key is created'
  call endit 1
end

/* Set default value */
if key='' then key='server.key'

/* Add path to keys directory if no directory specified */
if pos('\',key) = 0 then do
   key = '..\keys\' || key
end /* if */

/* Add extention '.key' if not present */
if translate(right(key,4)) \= '.KEY' then do
   key = key || '.key'
end /* if */

/* Create filename for CSR file */
csr = left(key,lastpos('.',key)) || 'csr'

say 'Creating a RSA private key for your Apache server'
say '(will be Triple-DES encrypted and PEM formatted)'
say

'openssl genrsa -des3 -out' key '1024 -config' conffile

say 'Creating a Certificate Signing Request (CSR)'
say 'with the server RSA private key (output will be PEM formatted)'
say
say 'Make sure you enter the FQDN ("Fully Qualified Domain Name") of the'
say 'server when OpenSSL prompts you for the "CommonName", i.e.  when you'
say 'generate a CSR for a website which will be later accessed via'
say 'https://www.foo.dom/, enter "www.foo.dom" here.  You can see the'
say 'details of this CSR via the command'
say

'openssl req -new -key' key '-out' csr '-config' conffile

say 'You now have to send this Certificate Signing Request (CSR)'
say 'to a Certifying Authority (CA) for signing'
say 'or you can use your own CA and now have to sign'
say 'the CSR yourself by this CA.'

call endit 0


/* Prepares exit and restores environment */
endit:

parse arg exitcode

if exitcode = '' then do
   exitcode = 1
end /* if */

call endlocal

exit exitcode
