/*
This REXX program decrypts a key
(C) Z. Wagner -- Ice Bear Soft, 30 Jan 2000
-------------------------------------------------------------------------------
For usage see ..\etc\manual.html
-------------------------------------------------------------------------------
[20010528] "Michael Warmuth" <michael@warmuth.at> (C) Michael Warmuth:
   + Added:   Setting of RANDFILE environment variable, SETLOCAL/ENDLOCAL,
              replacement of exit with endit, and providing a rand file
              as I have no dought about how to create one (and I found one
              on my system).
   + Added:   Some comments.
   + Changed: Directory structure with bin, certs, doc, etc, and keys
              subdirectories and default paths changed accordingly.
   + Changed: Routine to create CSR file name.
-------------------------------------------------------------------------------
[20000130] "Z. Wagner" <wagner@mbox.cesnet.cz> (C) Ice Bear Soft:
   + Added:   Initial release
-------------------------------------------------------------------------------
*/

call setlocal
'@echo off'

/* Configuration section */
call value 'RANDFILE','..\etc\OpenSSL.rnd','OS2ENVIRONMENT'

/* Get argument */
parse arg key rest

/* Check syntax */
if key='' | rest\='' then do
  say 'Usage: keydecrypt <key>'
  call endit 1
end

/* Add path to keys directory if no directory specified */
if pos('\',key) = 0 then do
   key = '..\keys\' || key
end /* if */

/* Add extention '.key' if not present */
if translate(right(key,4)) \= '.KEY' then do
   key = key || '.key'
end /* if */

/* Create filename for unsecure file */
unsecure = left(key,lastpos('.',key)) || 'unsecure'

'openssl rsa -in' key '-out' unsecure

call endit 0


/* Prepares exit and restores environment */
endit:

parse arg exitcode

if exitcode = '' then do
   exitcode = 1
end /* if */

call endlocal

exit exitcode
