/*
This REXX program displays the details of a key or a CSR
(C) Z. Wagner -- Ice Bear Soft, 30 Jan 2000
-------------------------------------------------------------------------------
For usage see ..\etc\manual.html
-------------------------------------------------------------------------------
[20010528] "Michael Warmuth" <michael@warmuth.at> (C) Michael Warmuth:
   + Added:   Setting of RANDFILE environment variable, SETLOCAL/ENDLOCAL,
              replacement of exit with endit, and providing a rand file
              as I have no dought about how to create one (and I found one
              on my system).
   + Added:   Default openssl.cnf file and parameter "-config" to all
              openssl.exe calls to use this file.
   + Added:   Some comments.
   + Changed: Directory structure with bin, certs, doc, etc, and keys
              subdirectories and default paths changed accordingly.
   + Changed: Routine to check type parameter.
   + Added:   Output of openssl via rxqueue to correct <CR><LF> problem and
              to add a pause after 21 lines of output.
   + Added:   Correct filetype depending on type.
-------------------------------------------------------------------------------
[20000130] "Z. Wagner" <wagner@mbox.cesnet.cz> (C) Ice Bear Soft:
   + Added:   Initial release
-------------------------------------------------------------------------------
*/

call setlocal
'@echo off'

/* Configuration section */
call value 'RANDFILE','..\etc\OpenSSL.rnd','OS2ENVIRONMENT'
conffile = '..\etc\OpenSSL.cnf'
typelist = 'rsa x509 req'
extlist  = '.key .crt .csr'

/* Get argument */
parse arg key type rest

/* Set default value */
if type='' then type = word(typelist,1)

/* Check syntax */
if key='' | rest\='' | wordpos(type,typelist) = 0 then do
  say 'Usage: keydetails <key> <type>'
  say '       <type> is one of:' typelist '(case sensitive)'
  say '       If <type> is not specified,' word(typelist,1) 'is assumed'
  call endit 1
end

/* Add path to keys directory if no directory specified */
if pos('\',key) = 0 then do
   key = '..\keys\' || key
end /* if */

/* Add correct extention if not present */
ext = word(extlist,wordpos(type,typelist))
if translate(right(key,4)) \= translate(ext) then do
   key = key || ext
end /* if */

if type = 'req' then do
   'openssl req -noout -text -in' key '-config' conffile '| rxqueue'
end /* if */
else do
   'openssl' type '-noout -text -in' key '| rxqueue'
end /* else */

/* Read rxqueue and correct <CR><LF> */
do i = 0 by 1 while queued() > 0
   parse pull output.i
   do while length(output.i) > 79
      j = i + 1
      parse var output.i output.i +79 output.j
      i = j
   end /* do */
end /* do */
output.0 = i - 1

/* Pause output after 21 lines */
do i = 1 to output.0
   say output.i
   if i // 21 = 0 then do
      say ''
      say 'Press Enter to continue...'
      parse pull .
   end /* if */
end /* do */


call endit 0


/* Prepares exit and restores environment */
endit:

parse arg exitcode

if exitcode = '' then do
   exitcode = 1
end /* if */

call endlocal

exit exitcode
