/*
This REXX program signs a certificate signing request
(C) Z. Wagner -- Ice Bear Soft, 30 Jan 2000
-------------------------------------------------------------------------------
For usage see ..\etc\manual.html
-------------------------------------------------------------------------------
[20010528] "Michael Warmuth" <michael@warmuth.at> (C) Michael Warmuth:
   + Added:   Setting of RANDFILE environment variable, SETLOCAL/ENDLOCAL,
              replacement of exit with endit, and providing a rand file
              as I have no dought about how to create one (and I found one
              on my system).
   + Added:   Some comments.
   + Changed: Directory structure with bin, certs, doc, etc, and keys
              subdirectories and default paths changed accordingly.
   + Changed: Routine to create CRT file name.
   + Removed: Config file content from comment (put into config file).
   + Changed: Added second parameter for certification authority CRT file.
-------------------------------------------------------------------------------
[20000130] "Z. Wagner" <wagner@mbox.cesnet.cz> (C) Ice Bear Soft:
   + Added:   Initial release
-------------------------------------------------------------------------------
*/

call setlocal
'@echo off'

/* Configuration section */
call value 'RANDFILE','..\etc\OpenSSL.rnd','OS2ENVIRONMENT'
conffile = '..\etc\OpenSSL.cnf'
cadir    = '..\certs\ca.db.certs'
caserial = '..\certs\ca.db.serial'
caindex  = '..\certs\ca.db.index'

/* Get argument */
parse arg csr cacrt rest

/* Check syntax */
if rest \= '' | csr = '' then do
  say 'Usage: sign <to-sign>.csr [<your-ca>.crt]'
  call endit 1
end

/* Add path to keys directory if no directory specified */
if pos('\',csr) = 0 then do
   csr = '..\keys\' || csr
end /* if */

/* Add extention '.csr' if not present */
if translate(right(csr,4)) \= '.CSR' then do
   csr = csr || '.csr'
end /* if */

/* Create filename for CRT file */
crt = left(csr,lastpos('.',csr)) || 'crt'

/* Set default value */
if cacrt='' then cacrt='ca.crt'

/* Add path to keys directory if no directory specified */
if pos('\',cacrt) = 0 then do
   cacrt = '..\keys\' || cacrt
end /* if */

/* Add extention '.crt' if not present */
if translate(right(cacrt,4)) \= '.CRT' then do
   cacrt = cacrt || '.crt'
end /* if */

/* Create filename for CA KEY file */
cakey = left(cacrt,lastpos('.',cacrt)) || 'key'

/* Create directory if necessary */
'@md' cadir '1> nul 2> nul'

/* Create serial no file if necessary */
if stream(caserial, 'c', 'query exists') = '' then do
  call lineout caserial, '01'
  call stream caserial, 'c', 'close'
end

/* Create database file if necessary */
if stream(caindex, 'c', 'query exists') = '' then do
  call stream caindex, 'c', 'open write'
  call stream caindex, 'c', 'close'
end

/* Create and verify certificates */
say "CA signing:" csr "->" crt || ":"
'openssl ca -config' conffile '-cert' cacrt '-keyfile' cakey,
           '-out' crt '-infiles' csr
say "CA verifying:" crt "<->" cacrt
'openssl verify -CAfile' cacrt crt

/* Delete backup copies of old files */
'del' caserial || '.old /F 1> nul 2> nul'
'del' caindex || '.old /F 1> nul 2> nul'

call endit 0


/* Prepares exit and restores environment */
endit:

parse arg exitcode

if exitcode = '' then do
   exitcode = 1
end /* if */

call endlocal

exit exitcode
