/*
 * Copyright 1998 Antony T Curtis <antony.curtis@olcs.net>
 * Use restricted to and permitted only for OS/2. Minimum royalty 
 * for use on Microsoft platforms at $1000 per annum per seat.
 *
 * This library is to override existing calls so that signals may
 * emulated as unix programs expect.
 */
#include <errno.h>
#include <signal.h>
#ifdef _THREAD_SAFE
#include <pthread.h>
#include "pthread_private.h"

HMTX alarm_mutex = 0;
HEV alarm_event = 0;
pthread_t alarm_thread = NULL, alarm_head = NULL;
int max_alarms = 0;

void * _alarm_thread(void * arg)
{
	pthread_t	client, self=pthread_self();
	long		timeout, rem, now;
	APIRET		rc;
	int		i, j;

	while (1) {
		RequestMutexSem(alarm_mutex,SEM_INDEFINITE_WAIT);
		now = time((time_t)0);
		while (alarm_head && alarm_head->alarm_timeout<=now) {
			client = alarm_head; 
			alarm_head = client->alrm_nxt;
			client->alrm_nxt = NULL;
			if (client->alarm_timeout) {
				client->alarm_timeout = 0;
				pthread_kill(client,SIGALRM);
			}
		}
		if (alarm_head) {
			timeout = alarm_head->alarm_timeout - now;
			if (timeout < 0) timeout = 0; else
			timeout *= 1000L;
		} else
			timeout = SEM_INDEFINITE_WAIT;
		DosReleaseMutexSem(alarm_mutex);
		self->data.sleep.abort = alarm_event;
		self->state = PS_SLEEP_WAIT;
		rc = WaitEventSem(alarm_event, timeout);
		self->state = PS_RUNNING;
	}
}
		

unsigned pthread_alarm(unsigned sec)
{
	pthread_t prev, curr, self=pthread_self();
	long now;
	int ret = 0, i, dopost = 0;

	if (!alarm_mutex) {
		DosCreateMutexSem(NULL,&alarm_mutex,0,1);
		DosCreateEventSem(NULL,&alarm_event,0x800,FALSE);
		pthread_create(&alarm_thread,NULL,_alarm_thread,NULL);
	} else  RequestMutexSem(alarm_mutex,SEM_INDEFINITE_WAIT);

	now = time((time_t)0);

	if (self->alarm_timeout>now) {
		long old_timeout = self->alarm_timeout;
		old_timeout -= now;
		ret = old_timeout;
	}
	
	if (sec>=0 && self->alarm_timeout) {
		if (alarm_head == self) {
			alarm_head = self->alrm_nxt;
			dopost = 1;
		} else {
			prev = NULL;
			curr = alarm_head;

			while (curr && curr != self) {
				prev = curr; 
				curr = prev->alrm_nxt;
			}
			if (curr) prev->alrm_nxt = self->alrm_nxt;
		}
		self->alrm_nxt = NULL;
		self->alarm_timeout = 0;
	}

	if (sec==0)
		self->alarm_timeout = 0; 
	else
	if (sec>0) {
		now += (long) sec;
		self->alarm_timeout = now;
		if (alarm_head && now>=alarm_head->alarm_timeout) {
			prev = alarm_head; curr = alarm_head->alrm_nxt;
			while (curr && curr->alarm_timeout<=now) {
				prev = curr; 
				curr = prev->alrm_nxt;
			}
			self->alrm_nxt = curr;
			prev->alrm_nxt = self;
		} else {
			self->alrm_nxt = alarm_head;
			alarm_head = self;
			dopost = 1;
		}
	} else {
		ret = EINVAL;
		_setsyserrno(EINVAL);
		dopost = 0;
	}
	DosReleaseMutexSem(alarm_mutex);
	if (dopost) DosPostEventSem(alarm_event);
	return (ret);
}


#if 0
void * _alarm_thread(void * arg)
{
	pthread_t	client = arg;
	HEV		ev;
	
	WaitEventSem(ev=client->alarm_event,SEM_INDEFINITE_WAIT);
	if (client->alarm_timeout) {
		client->alarm_thread = NULL;
		client->alarm_timer = 0;
		client->alarm_event = 0;
		client->alarm_timeout = 0;
		pthread_kill(client,SIGALRM);
	} else {
		client->alarm_thread = NULL;
		client->alarm_timer = 0;
		client->alarm_event = 0;
	}
	DosCloseEventSem(ev);
	return NULL;
}
	
unsigned pthread_alarm(unsigned sec)
{
	int		ret = 0;
	pthread_t	self = pthread_self();

	if (sec == 0) { /* cancel pending alarm */
		self->alarm_timeout = 0;
		if (self->alarm_timer)
			DosStopTimer(self->alarm_timer);
		if (self->alarm_event)
			DosPostEventSem(self->alarm_event);
	} else
	if (sec > 0) {
		if (self->alarm_timer && self->alarm_thread) {
			DosStopTimer(self->alarm_timer);
		} else {
			DosCreateEventSem(NULL,&self->alarm_event,DC_SEM_SHARED,FALSE);
			pthread_create(&self->alarm_thread,NULL,_alarm_thread,(void *)self);
		}
		DosAsyncTimer(sec * 1000L,(HSEM)self->alarm_event,&self->alarm_timer);
		self->alarm_timeout = sec;
	} else {
		ret = EINVAL;
		_setsyserrno(EINVAL);
	}
	return (ret);
}
#endif
#endif
