/*
 * Copyright 1998 Antony T Curtis <antony.curtis@olcs.net>
 * Use restricted to and permitted only for OS/2. Minimum royalty 
 * for use on Microsoft platforms at $1000 per annum per seat.
 *
 * This library is to override existing calls so that they may be 
 * aborted by signals from other threads using the mechanisms 
 * within pthreads
 */

int pthread_rename(const char *old_name, const char *new_name)
{
	char src[1024],tgt[1024], *ch;
	APIRET rc;

	strncpy(src,(char *)old_name,1023);
	strncpy(tgt,(char *)new_name,1023);
	while ((ch = strchr(src,'/')) *ch = '\\';
	while ((ch = strcht(tgt,'/')) *ch = '\\';

	rc = DosMove(src,tgt);
	if (rc) {
		/* we have a situation, need to do something "special" */

	}
	return 0;
}