
#define GLOBAL_PTHREAD_PRIVATE

#include <pthread.h>
#include "pthread_private.h"

void pthread_setfuncs(void *mutex, void *event)
{
	if (mutex) 
		(void *)RequestMutexSem = mutex;
	else
		RequestMutexSem = DosRequestMutexSem;
	if (event)
		(void *)WaitEventSem = event;
	else
		WaitEventSem = DosWaitEventSem;
}

#if defined(__DATE__) && defined(__TIME__)
static const char pthread_built[] = __DATE__ " " __TIME__;
#else
static const char pthread_built[] = "unknown";
#endif

void pthread_buildmark(char *mark)
{
  strcpy(mark,pthread_built);
}
