/* ieee.h (libextensions/gcc) */
/* 
 * Written by J.T. Conklin, Apr 6, 1995
 * Public domain.
 */
#ifndef _IEEE_H
#define _IEEE_H

typedef int fp_except;
#define FP_X_INV	0x01	/* invalid operation exception */
#define FP_X_DNML	0x02	/* denormalization exception */
#define FP_X_DZ		0x04	/* divide-by-zero exception */
#define FP_X_OFL	0x08	/* overflow exception */
#define FP_X_UFL	0x10	/* underflow exception */
#define FP_X_IMP	0x20	/* imprecise (loss of precision) */

typedef enum {
    FP_RN=0,			/* round to nearest representable number */
    FP_RM=1,			/* round toward negative infinity */
    FP_RP=2,			/* round toward positive infinity */
    FP_RZ=3			/* round to zero (truncate) */
} fp_rnd;

extern fp_rnd    fpgetround(void);
extern fp_rnd    fpsetround(fp_rnd);
extern fp_except fpgetmask(void);
extern fp_except fpsetmask(fp_except);
extern fp_except fpgetsticky(void);
extern fp_except fpsetsticky(fp_except);

#define _HIDDENBIT	1
#define _LENBASE	1
#define _EXPBASE	(1 << _LENBASE)

#define _DEXPLEN	11
#define DMAXEXP		((1 << _DEXPLEN - 1) - 1 + _IEEE)
#define DMINEXP		(-(DMAXEXP - 3))
#define DSIGNIF		(64 - _DEXPLEN + _HIDDENBIT - 1)
#define MAXDOUBLE	1.7976931348623157e+308
#define MINDOUBLE       2.2250738585072014e-308
#define LN_MAXDOUBLE	1418.87227860620804838
#define LN_MINDOUBLE	(-1417.48598424508815776)

#define _FEXPLEN	8
#define FMAXEXP		((1 << _FEXPLEN - 1) - 1 + _IEEE)
#define FMINEXP		(-(FMAXEXP - 3))
#define FSIGNIF		(32  - _FEXPLEN + _HIDDENBIT - 1)
#define MINFLOAT        1.17549435e-38
#define LN_MAXFLOAT	88.7228394
#define LN_MINFLOAT (-87.336544750553102)

#endif /* _IEEEFP_H_ */
