/* stdiox.h (emx+gcc) ADDITIONAL STREAMS UTILITIES for stdio.h */
#ifndef _STDIOX_H
#define _STDIOX_H

#if !defined (__STRICT_ANSI__) || defined(_WITH_UNDERSCORE)

/* Machine-dependent inline versions */
#if (!__GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ <= 7))
# define _IO_INL extern
#else
#define _IO_INL extern __inline__
#endif

#if defined(__cplusplus)
# ifndef __inline__ 
#  define __inline__ inline
# endif
extern "C" {
#endif

/* 4.4 BSD */
extern char*_fgetln(register FILE*,size_t*); 	/* Get an input line.
 *			  The returned pointer often (but not always)
 * points into a stdio buffer.  Fgetline does not alter the text of
 * the returned line (which is thus not a C string because it will
 * not necessarily end with '\0'), but does allow callers to modify
 * it if they wish. */



_IO_INL char*fgetln(register FILE*,size_t*);

#ifdef	__cplusplus
}
#endif

#if !(!__GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ <= 7))

_IO_INL char*fgetln(register FILE*f,size_t*s){return _fgetln(f,s);}

#endif

#endif /* ANSI */

#ifdef _DEBUG
# include <sys/debugx.h>
#endif

#endif /* _STDIOX_H */
