/* public domain stuff, hacked in a minute by holger */
/* $Header: /cvsroot/posix2/posix2/fixcrcr.c,v 1.4 2000/03/29 08:50:23 veit Exp $ */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <unistd.h>
#include <stdio.h>

int
main(int argc, const char*argv[]) 
{
	if (argc != 2) {
		fprintf(stderr,"\
FIXCRCR.EXE: Fix double carriage return (CR CR),\n\
             (public domain by holger, for posix/2).\n\
 WARNING:\n\
         Use only for plain ASCII files, will damage binaries! \n\n\
 Usage:\n\
   %s FILENAME\n",
		argv[0]);
		exit(1);
	} {
	FILE *fin,*fout;
	char tmppath[MAXPATHLEN];
	if ((fin=fopen(argv[1],"rb")) == NULL) {
		fprintf(stderr,"%s: Error open file %s\n",argv[0],argv[1]);
		exit (2);
	}
	sprintf(tmppath,"%s.tmp",argv[1]);
	if ((fout=fopen(tmppath,"wb")) == NULL) {
		fprintf(stderr,"%s: Error open file %s\n",argv[0],tmppath);
		exit (3);
	}{
	int dbl = 0;
	int c;
	while ( EOF != (c = getc(fin)) ) {
		if (c == 0x1a) 	/* sub/<CTRL Z>, skip end marker */
			break;
		if (c == 0x0d) { /* the evil DOS text CR has been detected! */
			if (dbl) 	/* double CR detected, skip */
				continue;
			dbl = 1;
	}
		else  		/* no CR -> no double CR */
			dbl = 0;
		if ( EOF == putc(c, fout) ) /* set error indicator; evaluate later */
			break;
	}}
	if ( ferror(fin) ) { 	/* this is severe, exit to prevent data loss! */
		fclose(fin); fclose(fout); 
		unlink(tmppath);
		fprintf(stderr,"\
%s: I/O-error while reading file %s\n. Exiting to prevent data corruption...",
			argv[0],tmppath);
		exit (4);
	}
	/* cleanup */
	if ( fclose(fin) || fclose(fout) ) {
		fprintf(stderr,"\
%s: Error closing file %s or file %s\n",
			argv[0], argv[1], tmppath);
		exit (5);
	}
	if (chmod(argv[1],0777) != 0) {
		fprintf(stderr,"%s: Error chmod file %s\n",argv[0],argv[1]);
		exit (6);
	}
	if (unlink(argv[1]) != 0) {
		fprintf(stderr,"%s: Error unlink file %s\n",argv[0],argv[1]);
		exit (7);
	}
	if (rename(tmppath,argv[1]) != 0) {
		fprintf(stderr,"%s: Error updating file %s\n",argv[0],argv[1]);
		exit (8);
	}}
	exit (0);
}
