#define INCL_DOSPROCESS
#define INCL_DOSMEMMGR
#include <os2.h>

#include <sys/builtin.h>
#include <sys/smutex.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <errno.h>
#include <sys/errnox.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

static _smutex shm_lock = 0;

static int findkey(key_t key);
static int newseg(key_t key, int shmflg, size_t size);
static int killseg(int id);

static int max_shmid = SHMMNI;
static struct shmid_ds *shm_segs[SHMMNI];
static struct shmid_ds shm_data[SHMMNI];
static unsigned char defer_rm[SHMMNI];

static unsigned short shm_seq = 0; /* incremented, for recognizing stale ids */

/* Check user, group, other permissions for access
 * to ipc resources. return 0 if allowed; cf. sys/ipc.h
 */
	extern int
__SHMx_ipcperm(struct ucred *dummy, struct ipc_perm *ipcp, int flag)
{ /* adapt to real group/security management */
 /* flag, probably 0 or SHM_*: */
 int requested_mode = (flag >> 6) | (flag >> 3) | flag; /* Fix me! */
 int granted_mode = ipcp->mode;
	granted_mode >>= 6;
	/* is there some bit set in requested_mode but not in granted_mode? */
	if (requested_mode & ~granted_mode & 0007)
		return -1;
	return 0;
}

/* You must initialize shm! The dll init does it for you, if you are lucky.
 */
	extern void 
__SHMx_shmInit(void)
{
        int id;

        _dPuts("shm_init()\n");
        _smutex_request(&shm_lock);
        for (id = 0; id < SHMMNI; id++)
                shm_segs[id] = (struct shmid_ds *) IPC_UNUSED;
        _smutex_release(&shm_lock);
	return;
}

	extern void 
__SHMx_shmDone(void)
{
 int id;

        _dPuts("shm_done()\n");
        for (id = 0; id < SHMMNI; id++) {
                _smutex_request(&shm_lock);
                killseg(id);
                shm_segs[id] = (struct shmid_ds *) IPC_UNUSED;
                _smutex_release(&shm_lock);
        }
}

	static int 
findkey(key_t key)
{
        int id;
        struct shmid_ds *shp;

        for (id = 0; id <= max_shmid; id++) {
                while ((shp = shm_segs[id]) == IPC_NOID) {
                        _smutex_request(&shm_lock);
                        _dPuts("findkey()\n");
                        _smutex_release(&shm_lock);
                }
                if (shp == IPC_UNUSED)
                        continue;
                if (key == shp->shm_perm.key)
                        return id;
        }
        return (int)IPC_UNUSED;
}

static int idCount = 0;

/* allocate new shmid_ds. protected by shm_segs[id] = NOID.
 */
   /* needs complete overhaul, severely broken ! Fix me! */
	static int
newseg(key_t key, int shmflg, size_t size)
{
        if (size < SHMMIN) {
                errno = EINVAL; return(-1);
        } 
        while(idCount < SHMMNI) {
                if (shm_segs[idCount] == IPC_UNUSED) {
                        _smutex_request(&shm_lock);
                        shm_segs[idCount] = (struct shmid_ds*)IPC_NOID;
                        goto found;
                }
                ++idCount;
         }
         errno = ENOSPC; 
         return(-1);

found:  {
        	struct shmid_ds *
        shp = &shm_data[idCount];
        	APIRET
        rc = DosAllocSharedMem(&shp->shm_pages, NULL, size,
							OBJ_GETTABLE | PAG_COMMIT | PAG_READ | PAG_WRITE);
        if (rc) {
                shm_segs[idCount] = (struct shmid_ds*)IPC_UNUSED;
                _smutex_release(&shm_lock);
                _dPrintf("\
shmx.c: newseg(): Error returned by DosAllocSharedMem: # %ld\n", rc);
                errno = _rc2Errno(rc);
                return(-1);
        } else
          _dPuts("DosAllocSharedMem() successful\n");

        shp->shm_perm.key = key;
        shp->shm_perm.mode = shmflg;
        shp->shm_perm.cuid = shp->shm_perm.uid = 0;
        shp->shm_perm.cgid = shp->shm_perm.gid = 0;
        shp->shm_perm.seq = shm_seq;
        shp->shm_segsz = size;
        shp->shm_cpid = getpid();
        shp->shm_lpid = shp->shm_nattch = 0;
        shp->shm_atime = shp->shm_dtime = 0;
        shp->shm_ctime = time(NULL);

        if (idCount > max_shmid) {
                errno = ENOMEM; return(-1);
        }
        shm_segs[idCount] = shp;
	defer_rm[idCount] = 0;
        _smutex_release(&shm_lock);
        _dPuts("newseg() successful\n");

        return (unsigned int)shp->shm_perm.seq * SHMMNI + idCount;
        }
}


	extern int 
shmctl(int shmid, int cmd, struct shmid_ds *buf)
{
		struct shmid_ds tbuf;
		struct shmid_ds *shp;
		struct ipc_perm *ipcp;
		int id;

		if (cmd < 0 || shmid < 0) 
					 {errno = EINVAL;  return -1;}
		if (cmd == IPC_SET) 
					 {errno = EINVAL;  return -1;}

		switch (cmd) { /* replace with proc interface ? */
        case IPC_INFO: {
                struct shminfo shminfo;
                if (!buf)
                  { errno = EFAULT; return -1; }
                shminfo.shmmni = SHMMNI;
                shminfo.shmmax = SHMMAX;
                shminfo.shmmin = SHMMIN;
                shminfo.shmall = SHMALL;
                shminfo.shmseg = SHMSEG;
                memcpy (buf, &shminfo, sizeof(struct shminfo));
                return(max_shmid);
        }
        case SHM_INFO: {
               errno = EINVAL;  return -1;
        }
        case SHM_STAT: 
                if (!buf)
                  { errno = EFAULT; return -1; }
                if (shmid > max_shmid)
                   {errno = EINVAL;  return -1;}
                shp = shm_segs[shmid];
                if (shp == IPC_UNUSED || shp == IPC_NOID)
                   {errno = EINVAL;  return -1;}
                if (__SHMx_ipcperm(NULL, &shp->shm_perm, S_IRUGO))
                        {errno = EACCES; return(-1);}
                id = (unsigned int)shp->shm_perm.seq * SHMMNI + shmid;
                tbuf.shm_perm   = shp->shm_perm;
                tbuf.shm_segsz  = shp->shm_segsz;
                tbuf.shm_atime  = shp->shm_atime;
                tbuf.shm_dtime  = shp->shm_dtime;
                tbuf.shm_ctime  = shp->shm_ctime;
                tbuf.shm_cpid   = shp->shm_cpid;
                tbuf.shm_lpid   = shp->shm_lpid;
                tbuf.shm_nattch = shp->shm_nattch;
                memcpy(buf, &tbuf, sizeof(*buf));
                return(id);
        }

        shp = shm_segs[id = (unsigned int)shmid % SHMMNI];
        if (shp == IPC_UNUSED || shp == IPC_NOID)
               {errno = EINVAL;  return -1;}
        if (shp->shm_perm.seq != (unsigned int) shmid / SHMMNI)
                {errno = EIDRM; return -1; }
        ipcp = &shp->shm_perm;

    switch (cmd) {
        case SHM_UNLOCK:
               {errno = EINVAL;  return -1;}
        case SHM_LOCK:
               {errno = EINVAL;  return -1;}
        case IPC_STAT:
                if (__SHMx_ipcperm(NULL, ipcp, S_IRUGO))
                  {errno = EACCES; return -1; }
                if (!buf)
                  {errno = EFAULT; return -1; }

                tbuf.shm_perm   = shp->shm_perm;
                tbuf.shm_segsz  = shp->shm_segsz;
                tbuf.shm_atime  = shp->shm_atime;
                tbuf.shm_dtime  = shp->shm_dtime;
                tbuf.shm_ctime  = shp->shm_ctime;
                tbuf.shm_cpid   = shp->shm_cpid;
                tbuf.shm_lpid   = shp->shm_lpid;
                tbuf.shm_nattch = shp->shm_nattch;
                memcpy (buf, &tbuf, sizeof(*buf));
                break;
        case IPC_SET:
                {errno = EPERM; return -1;}
        case IPC_RMID:
                if (shp->shm_nattch <= 0) {
                  _smutex_request(&shm_lock);
                  killseg (id);
                  _smutex_release(&shm_lock);
                }
                else
                  defer_rm[id] = 1;
                break;
        default:
               {errno = EINVAL;  return -1;}
        }
        return 0;
}

	extern int 
shmget(key_t key, int size, int shmflg)
{
        struct shmid_ds *shp;
        int id = 0;

        if (size < 0 || size > SHMMAX) {
                errno = EINVAL; return(-1);
        }
        if (key == IPC_PRIVATE)
                return newseg(key, shmflg, (size_t)size);
        if ((id = findkey (key)) == -1) {
                if (!(shmflg & IPC_CREAT))
                        return(-(errno = ENOENT));
                return newseg(key, shmflg, (size_t)size);
        }
        if ((shmflg & IPC_CREAT) && (shmflg & IPC_EXCL))
                return -EEXIST;
        shp = shm_segs[id];
        if (size > shp->shm_segsz)
               {errno = EINVAL;  return -1;}
        if (__SHMx_ipcperm(NULL, &shp->shm_perm, shmflg))
                return -EACCES;
        _dPuts("shmget() successful");
        return (unsigned int) shp->shm_perm.seq * SHMMNI + id;
}


/*
 * Here pages and shmid_ds are freed.
 */
	static int 
killseg(int id)
{
	int i, numpages;

		struct shmid_ds *
	shp = shm_segs[id];
		
        if (shp == IPC_NOID || shp == IPC_UNUSED) {
                return -EFAULT;
        }
        shp->shm_perm.seq++;     /* for shmat */
        shm_seq = (shm_seq+1) % ((unsigned)(1<<30)/SHMMNI); /* increment, but avoid overflow */
        shm_segs[id] = (struct shmid_ds *) IPC_UNUSED;
        if (id == max_shmid)
                while (max_shmid && (shm_segs[--max_shmid] == IPC_UNUSED));
        if (!shp->shm_pages) {
                return -EFAULT;
        }
	defer_rm[id] = 0;

#if 0
/* DosFreeMem() decrements a reference count,
   so it should be called in shmdt() */
        APIRET rc = DosFreeMem(shp->shm_pages);
        if (rc)
          _dPuts("DosFreeMem() failed\n");
        else
          _dPuts("DosFreeMem() successful\n");
#endif

        _dPuts("killseg() successful");
        return IPC_PRIVATE;
}

/*
 * Fix shmaddr, allocate descriptor, map shm, add attach descriptor to lists.
 */
	extern void *
shmat(int shmid, const void *shmaddr, int shmflg)
{
        struct shmid_ds *shp;
        unsigned int id;
        APIRET rc;

        if (shmid < 0) {
                errno = EINVAL;  return (void*)-1;
        }

        shp = shm_segs[id = (unsigned int) shmid % SHMMNI];
        if (shp == IPC_UNUSED || shp == IPC_NOID) {
                errno = EINVAL;  return (void*)-1;
        }

        if (shmaddr) {
                errno = EINVAL;  return (void*)-1;
        }

_dPuts("shmat() 1 ...\n");

        if (__SHMx_ipcperm(NULL, &shp->shm_perm, shmflg & 
                     SHM_RDONLY ? S_IRUGO : S_IRUGO|S_IWUGO))
                {errno = EACCES; return (void*) -1;}

        if (shp->shm_perm.seq != (unsigned int) shmid / SHMMNI)
                {errno = EIDRM; return (void*)-1;}


        if ((shp != shm_segs[id]) || (shp->shm_perm.seq != 
                 		(unsigned int)shmid / SHMMNI)) {
                {errno = EIDRM; return (void*)-1;}
        }

_dPuts("shmat() 2 ...\n");

        shp->shm_nattch++;            /* prevent destruction */

        shp->shm_lpid = getpid();
        shp->shm_atime = time(NULL);

        rc = DosGetSharedMem(shp->shm_pages, PAG_READ | PAG_WRITE );
        if (rc) {
                _dPuts("DosGetSharedMem() failed\n");
                errno = _rc2Errno(rc); return (void*)-1; 
        } else
          _dPuts("DosGetSharedMem() successful\n");

        return shp->shm_pages;
}

/*
 * detach segment
 */
	extern int 
shmdt(const void *shmaddr)
{

        int id;
        struct shmid_ds *shp;

        for (id = 0; id <= max_shmid; id++) {
                while ((shp = shm_segs[id]) == IPC_NOID) {
                        _smutex_request(&shm_lock);
                        _smutex_release(&shm_lock);
                }
                if (shp == IPC_UNUSED)
                        continue;
                if (((size_t)shp->shm_pages <= (size_t)shmaddr) && 
                	((size_t)shmaddr <=
                	 ((size_t)shp->shm_pages + (size_t)shp->shm_segsz))) {
                        if (shp->shm_nattch) {
			  shp->shm_nattch--;
			/* DosFreeMem() decrements a reference count,
			   so it should be called here */
		          DosFreeMem(shp->shm_pages);
			}
			if (shp->shm_nattch == 0 && defer_rm[id]) killseg(id);
                        _dPuts("shmdt() successful\n");
                        return IPC_PRIVATE;
                }
        }
        return (int) IPC_UNUSED;
}

/* Display information about active shared memory segments */
	extern void
_SHMx_showActiveSeg(void)
{
        int id;
        struct shmid_ds *shp;

	printf("active shared memory segments\n");
	printf("=============================\n");
        for (id = 0; id <= max_shmid; id++) {
                while ((shp = shm_segs[id]) == IPC_NOID) {
                        _smutex_request(&shm_lock);
                        _smutex_release(&shm_lock);
                }
                if (shp != IPC_UNUSED || defer_rm[id]) {
                        _smutex_request(&shm_lock);
			printf("id = %d, key = %d, nattch = %d\n",
				id, (int)shp->shm_perm.key, shp->shm_nattch);
                        _smutex_release(&shm_lock);
                }
        }
}

