/* stdlibx.h (libext+gcc) - ADDITIONAL GENERAL UTILITIES for stdlib.h */
/* $Id: stdlibx.h,v 1.4 2000/04/03 18:18:24 veit Exp $ */

#ifndef _SYS_STDLIBX_H
#define _SYS_STDLIBX_H

#include <stdlib.h>

#if defined(__cplusplus)
# ifndef __inline__ 
#  define __inline__ inline
# endif
extern "C" {
#endif

#if !defined (__STRICT_ANSI__) || defined(_WITH_UNDERSCORE)

/* Machine-dependent inline versions */
#if (!__GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ <= 7))
# define _STD_INL extern
#else
#define _STD_INL extern __inline__
#endif

extern __const__ unsigned int _libExtensions_vcmp; /* lib version */
extern __const__ unsigned int _libExtensions_env;
extern __const__ unsigned int _libExtensions_rev;
extern __const__ char         _libExtensions_vprt[5];

/* bsd 4.4 */
extern void _srandom(unsigned long);
extern void _srandomdev(void);
extern char*_initstate(unsigned long,char*,long);
extern char*_setstate(char*);
extern long _random(void);
extern int _heapsort(register void*,register size_t,register size_t,
  int(*c)(__const__ void*,__const__ void*));
extern int _radixsort(__const__ unsigned char**,int,__const__ unsigned char*,unsigned);
extern int _sradixsort(__const__ unsigned char**,int,__const__ unsigned char*,unsigned);


#if !defined (__STRICT_ANSI__) || defined(_WITH_UNDERSCORE)

/* stubs
 */
extern int daemon(int,int); /* OS/2 uses detached processes instead! */
extern int _daemon(int,int); /* OS/2 uses detached processes instead! */

/* System V style 48-bit random number generator functions: 
    Seed random number generator.
  */
extern void srand48(long);
extern unsigned short*seed48(unsigned short[3]);
extern void lcong48(unsigned short[7]);
   /*  Return non-negative, double-precision floating-point value in [0.0,1.0).
    */
extern double drand48(void);
extern double erand48(unsigned short[3]);
  /* Return non-negative, long integer in [0,2^31).
   */
extern long lrand48(void);
extern long nrand48(unsigned short[3]);
  /* Return signed, long integers in [-2^31,2^31).
   */
extern long mrand48(void);
extern long jrand48(unsigned short[3]);

extern void*valloc(size_t);


_STD_INL void srandom(unsigned long);
_STD_INL void srandomdev(void);
_STD_INL char* initstate(unsigned long seed, char*arg_state, long n);
_STD_INL char* setstate(char*);
_STD_INL long random(void);
_STD_INL int heapsort(register void*,register size_t,register size_t,
  int(*c)(__const__ void*,__const__ void*));
_STD_INL int radixsort(__const__ unsigned char**,int,__const__ unsigned char*,unsigned);
_STD_INL int sradixsort(__const__ unsigned char**,int,__const__ unsigned char*,unsigned);

#if !(!__GNUC__ || __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ <= 7))

	_STD_INL void
srandom(unsigned long s) {return _srandom(s);}
	_STD_INL void
srandomdev(void) {return _srandomdev();}
	_STD_INL char *
initstate(unsigned long s,char*a,long n) {return _initstate(s,a,n);}
	_STD_INL char *
setstate(char*c) {return setstate(c);}
	_STD_INL long
random(void) {return _random();}
	_STD_INL int
heapsort(register void*b,register size_t n,register size_t s,
  int(*c)(__const__ void*,__const__ void*)){return _heapsort(b,n,s,c);}
	_STD_INL int
radixsort(__const__ unsigned char **a,int n,__const__ unsigned char*t,
	unsigned e) {return _radixsort(a,n,t,e);}
	_STD_INL int
sradixsort(__const__ unsigned char **a,int n,__const__ unsigned char*t,
	unsigned e) {return _sradixsort(a,n,t,e);}

#endif /* GNUC, etc. */

#endif /* ANSI */
#endif /* UNDERSCORE, etc. */

#ifdef	__cplusplus
}
#endif

#ifdef _DEBUG
# include <sys/debugx.h>
#endif

#endif /* _SYS_STDLIB_H */
