/* libext+gcc: sys/systm.h - $Id: systm.h,v 1.1 2000/04/17 08:25:12 veit Exp $	*/

/*-
 * Copyright (c) 1982, 1988, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)systm.h	8.4 (Berkeley) 2/23/94
 */

#ifndef __SYSTM_H__
#define __SYSTM_H__

#include <machine/stdarg.h>

/*
 * The `securelevel' variable controls the security level of the system.
 * It can only be decreased by process 1 (/sbin/init).
 *
 * Security levels are as follows:
 *   -1	permanently insecure mode - always run system in level 0 mode.
 *    0	insecure mode - immutable and append-only flags make be turned off.
 *	All devices may be read or written subject to permission modes.
 *    1	secure mode - immutable and append-only flags may not be changed;
 *	raw disks of mounted filesystems, /dev/mem, and /dev/kmem are
 *	read-only.
 *    2	highly secure mode - same as (1) plus raw disks are always
 *	read-only whether mounted or not. This level precludes tampering
 *	with filesystems by unmounting them, but also inhibits running
 *	newfs while the system is secured.
 *
 * In normal operation, the system runs in level 0 mode while single user
 * and in level 1 mode while multiuser. If level 2 mode is desired while
 * running multiuser, it can be set in the multiuser startup script
 * (/etc/rc.local) using sysctl(1). If it is desired to run the system
 * in level 0 mode while multiuser, initialize the variable securelevel
 * in /sys/kern/kern_sysctl.c to -1. Note that it is NOT initialized to
 * zero as that would allow the vmunix binary to be patched to -1.
 * Without initialization, securelevel loads in the BSS area which only
 * comes into existence when the kernel is loaded and hence cannot be
 * patched by a stalking hacker.
 */
extern int securelevel;		/* system security level */
extern __const__ char *panicstr;	/* panic message */

#if 0
extern int nblkdev;		/* number of entries in bdevsw */
extern int nchrdev;		/* number of entries in cdevsw */
#if !defined(UVM)
extern int nswdev;		/* number of swap devices */
extern int nswap;		/* size of swap space */
#endif

extern int selwait;		/* select timeout address */
#endif
extern u_char curpriority;	/* priority of current process */

extern int maxmem;		/* max memory per process */
extern int physmem;		/* physical memory */

extern dev_t dumpdev;		/* dump device */
extern long dumplo;		/* offset into dumpdev */

extern dev_t rootdev;		/* root device */
extern struct vnode *rootvp;	/* vnode equivalent to above */

extern dev_t swapdev;		/* swapping device */
extern struct vnode *swapdev_vp;/* vnode equivalent to above */

struct proc;
extern struct sysent {		/* system call table */
	short	sy_narg;	/* number of args */
	short	sy_argsize;	/* total size of arguments */
				/* implementing function */
	int(*sy_call)(struct proc *, void *, register_t*);
} sysent[];
#define	SCARG(p,k)((p)->k.datum)	/* get arg from args pointer */

#if defined(_KERNEL) && defined(SYSCALL_DEBUG)
void scdebug_call(struct proc *p, register_t code, register_t retval[]);
void scdebug_ret(struct proc *p, register_t code, int error, register_t retval[]);
#endif /* _KERNEL && SYSCALL_DEBUG */
#if defined(_KERNEL)
extern int boothowto;		/* reboot flags, from console subsystem */

extern void (*v_putc)(int); /* Virtual console putc routine */

extern	void	_insque(void *, void*);
extern	void	_remque(void*);

/* casts to keep lint happy, but it should be happy with void * */
#define	insque(q,p)	_insque(q, p)
#define	remque(q)	_remque(q)

/*
 * General function declarations.
 */
int	nullop(void*);
int	enodev(void);
int	enosys(void);
int	enoioctl(void);
int	enxio(void);
int	eopnotsupp(void*);

int	lkmenodev(void);

struct vnodeopv_desc;
void vfs_opv_init(void);
void vfs_opv_init_explicit(struct vnodeopv_desc*);
void vfs_opv_init_default(struct vnodeopv_desc*);
void vfs_op_init(void);

int	seltrue(dev_t dev, int which, struct proc*);
void	*hashinit(int, int, int, u_long*);
int	sys_nosys(struct proc *, void *, register_t*);

void	panic(__const__ char *, ...))
#ifdef __KPRINTF_ATTRIBUTE__
    __kprintf_attribute__((__noreturn__,__format__(__kprintf__,1,2);
#else
    __attribute__((__noreturn__);
#endif
void	__assert(__const__ char *, __const__ char *, int, __const__ char *))
    __attribute__((__noreturn__);
int	printf(__const__ char *, ...))
    __kprintf_attribute__((__format__(__kprintf__,1,2)));
void	uprintf(__const__ char *, ...))
    __kprintf_attribute__((__format__(__kprintf__,1,2)));
void	vprintf(__const__ char *, _BSD_VA_LIST_);
int	vsprintf(char *, __const__ char *, va_list)
    __kprintf_attribute__((__format__(__kprintf__,2,3)));
int	sprintf(char *buf, __const__ char *, ...)
    __kprintf_attribute__((__format__(__kprintf__,2,3)));
struct tty;
void	ttyprintf(struct tty *, __const__ char *, ...)
    __kprintf_attribute__((__format__(__kprintf__,2,3)));

void	tablefull(__const__ char*);

#if defined(UVM)
int	kcopy(__const__ void *, void *, size_t);
#endif

void	bcopy(__const__ void *, void *, size_t);
void	ovbcopy(__const__ void *, void *, size_t);
void	bzero(void *, size_t);
int	bcmp(__const__ void *, __const__ void *, size_t);
void	*memcpy(void *, __const__ void *, size_t);
void	*memmove(void *, __const__ void *, size_t);
void	*memset(void *, int, size_t);

int	copystr(__const__ void *, void *, size_t, size_t*);
int	copyinstr(__const__ void *, void *, size_t, size_t*);
int	copyoutstr(__const__ void *, void *, size_t, size_t*);
int	copyin(__const__ void *, void *, size_t);
int	copyout(__const__ void *, void *, size_t);

int	fubyte(void*);
#ifdef notdef
int	fuibyte(void*);
#endif
int	subyte(void *, int);
int	suibyte(void *, int);
long	fuword(void*);
long	fuiword(void*);
int	suword(void *, long);
int	suiword(void *, long);
int	fuswintr(caddr_t);
int	suswintr(caddr_t, u_int);

struct timeval;
int	hzto(struct timeval*);
void	timeout(void (*)(void *), void *, int);
void	untimeout(void (*)(void *), void*);
void	realitexpire(void*);

struct clockframe;
void	hardclock(struct clockframe*);
void	softclock(void);
void	statclock(struct clockframe*);
#ifdef NTP
void	hardupdate(long offset);
#ifdef PPS_SYNC
void	hardpps(struct timeval *, long);
#endif
#endif

void	initclocks(void);
void	inittodr(time_t);
void	resettodr(void);
void	cpu_initclocks(void);

void	startprofclock(struct proc*);
void	stopprofclock(struct proc*);
void	setstatclockrate(int);

/*
 * Shutdown hooks.  Functions to be run with all interrupts disabled
 * immediately before the system is halted or rebooted.
 */
void	*shutdownhook_establish(void (*)(void *), void*);
void	shutdownhook_disestablish(void*);
void	doshutdownhooks(void);

struct uio;
int	uiomove(caddr_t, int, struct uio*);

int	setjmp(label_t*);
void	longjmp(label_t*);

void	consinit(void);

void	cpu_startup(void);
void	cpu_set_kpc(struct proc *, void (*)(void *), void*);
extern void (*md_diskconf)(void);


#ifdef GPROF
void	kmstartup(void);
#endif

int nfs_mountroot(void);
int dk_mountroot(void);
int (*mountroot)(void);
#include <lib/libkern/libkern.h>
#if defined(DDB) || defined(KGDB)
/* debugger entry points */
void	Debugger(void);	/* in DDB only */
int	read_symtab_from_file(struct proc *,struct vnode *,__const__ char*);
#endif

#ifdef BOOT_CONFIG
void	user_config(void);
#endif
#endif /* Kernel */
#endif /* __SYSTM_H__ */

