/* sys/param.h (gcc/libextensions: BSD compatibility header) */
/* $Id: param.h,v 1.5 2000/04/26 13:16:38 veit Exp $ */

#ifndef _SYS_PARAM_H
#define _SYS_PARAM_H

#if defined (__cplusplus)
extern "C" {
#endif

/*- Parts:
 * Copyright (c) 1982, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)param.h	8.2 (Berkeley) 1/21/94
 */
/* 
 * We want to remain source compatible with emx legacy and to provide 
 * most of that hackish stuff that BSD expects to be here. Pls report
 * all outstanding bugs! We kow: The macros here severely pollute the 
 * namespace and violate the important ANSI rule to underscore all 
 * symbols in system libaries!
 */
#define INSECURE (-1) 	/* no BSD security features yet; cf. sys/sysctl.h */

/*
 * System parameter formulae; it should be modified there to suit local taste
 * if necessary; cf. param.c.
 *
 * Compiled with -DCLOCKS_PER_SEC=xx -DTIME_ZONE__=x -D_DST=x -D_MAXUSERS=xx

  ARG_MAX 
          length of arguments and environment for exec*(), in bytes

  CHILD_MAX 
          number of simultaneous processes per real user ID
          
  CLK_TCK 
          number of clock ticks per second, for times() 

  NGROUPS_MAX 
          maximum number of simultaneous supplementary group IDs per process

  OPEN_MAX 
          number of files that one process can have open at one time 

  STREAM_MAX 
          number of streams that one process can have open at one time 

  TZNAME_MAX 
          number of bytes supported for the name of a time zone

  JOB_CONTROL 
          defined if the implementation supports job control -- emx doesn't

  SAVED_IDS 
          defined if each process has a saved set-user-ID and a saved 
          set-group-ID -- not true for emx

  VERSION 
          corresponds to _POSIX_VERSION (the integer 199009L) 

  See POSIX.1 for more details. 

 * MAXCOMLEN should be >= sizeof(ac_comm) (see <acct.h>)
 * MAXLOGNAME should be >= UT_NAMESIZE (see <utmp.h>)
 */
#include <time.h>
#ifndef TIME_ZONE__
# define TIME_ZONE__ 0
#endif
#ifndef _DST
# define _DST 0
#endif
#ifndef _HZ
#define	_HZ CLOCKS_PER_SEC
#else
#undef CLK_TCK
#undef CLOCKS_PER_SEC
#define	CLOCKS_PER_SEC 	_HZ 
#define	CLK_TCK 	_HZ 
#endif
#ifndef MAXUSERS
#define MAXUSERS 100
#endif
#define	NPROC (20 + 16 * MAXUSERS) /* OS/2 supports up to 4095 processes/threads */
#define	NTEXT (80 + NPROC / 8)	/* actually the object cache */
/* #define	NVNODE (NPROC * 2 + NTEXT + 100) */

#define MAXHOSTNAMELEN	120	/* max length of hostname; cf. OS/2 toolkit */
#define _PARAM_HOST_NAME 	"libextp2host"
#define _PARAM_DOMAIN_NAME  	"libextp2domain"
#define _PARAM_HOST_ID 		0xffffffff
#define	NZERO		 15	/* No! default BSD "nice" feature!! */
#define	MAXCOMLEN        16	/* max command name remembered */
#define	MAXINTERP  	 64	/* max interpreter file name length */
#define	MAXLOGNAME	  0	/* No! max login name length. */
#define	ARG_MAX	    (8 * 1024)	/* max bytes for an exec function (safe?) */
#define	NCARGS	    ARG_MAX
#define	CHILD_MAX   80		/* max simultaneous processes (safe?) */
#define	MAXUPRC     CHILD_MAX	/* max simultaneous processes per user */

#define	OPEN_MAX    256		/* max open files per process (safe?) */
#define	NOFILE      OPEN_MAX	/* max open files per process (soft) */
#define	NOFILE_MAX  1024	/* max open files per process (hard) */

extern int _setMaxFiles(int);  /* set/return maximal file handles or -1 (error) */

#ifndef	NGROUPS
#define NGROUPS_MAX 	512	/* no groups; equiv. to sessions??  */
#define	NGROUPS	NGROUPS_MAX 	/* supplemental group IDs are available */
#endif
#ifndef NOGROUP
#define NOGROUP	(-1)		/* marker for empty group set member */
#endif

#define MAX_INPUT _POSIX_MAX_INPUT /* max size of the type-ahead buffer */
#define MAX_CANON _POSIX_MAX_CANON
#define	CANBSIZ	  MAX_CANON 	/* max bytes in term canonical input line */

/* Machine type dependent parameters. */
#define	_MACHINE	i386
#define	MACHINE		"i386"
#define	_MACHINE_ARCH	i386
#define	MACHINE_ARCH	"i386"
#define	MID_MACHINE	MID_I386
#define _PARAM_CPU_MODEL "Intel 486 (486-class)" /* anybody still using 386? 
	anyway, this is good, if you compile with -m486. If you compile 
	with -mpentium, tell it the user and define:
	#define _PARAM_CPU_MODEL "Intel Pentium (586-class)"
	*/

#define PIPE_BUF   4096		/* max bytes for atomic pipe writes (safe?) */


#include <sys/types.h>		/* BSD expects sys/types.h in sys/param.h */
	/* #include <sys/simplelock.h> ?? Need that??*/

/* Signals. BSD even expects this one to be here?! */
#include <sys/signal.h>

/*
 * Round p (pointer or byte index) up to a correctly-aligned value
 * for all data types (int, long, ...).   The result is u_int and
 * must be cast to any desired pointer type.
 */
#define ALIGNBYTES	(sizeof(int) - 1)
#define ALIGN(p)	(((u_int)(p) + ALIGNBYTES) &~ ALIGNBYTES)

#define	PGSHIFT		12		/* LOG2(NBPG) */
#define	NBPG		(1 << PGSHIFT)	/* bytes/page: 0x1000 */
#define	PGOFSET		(NBPG-1)	/* byte offset into page */
#define	NPTEPG		(NBPG/(sizeof (pt_entry_t)))

#define	DEV_BSHIFT	9		/* log2(DEV_BSIZE) */
#define	DEV_BSIZE	(1 << DEV_BSHIFT)
#define	BLKDEV_IOSIZE	2048
#define	MAXPHYS		(64 * 1024)	/* max raw I/O transfer size */

#define	CLSIZELOG2	0
#define	CLSIZE		(1 << CLSIZELOG2)

/* NOTE: SSIZE, SINCR and UPAGES must be multiples of CLSIZE */
#define	SSIZE		1		/* initial stack size/NBPG */
#define	SINCR		1		/* increment of stack/NBPG */
#define	UPAGES		2		/* pages of u-area */
#define	USPACE		(UPAGES * NBPG)	/* total size of u-area */

/*
 * Constants related to network buffer management.
 * MCLBYTES must be no larger than CLBYTES (the software page size), and,
 * on machines that exchange pages of input or output buffers with mbuf
 * clusters (MAPPED_MBUFS), MCLBYTES must also be an integral multiple
 * of the hardware page size.
 */
#define	MSIZE		128		/* size of an mbuf */
#define	MCLSHIFT	11		/* convert bytes to m_buf clusters */
#define	MCLBYTES	(1 << MCLSHIFT)	/* size of a m_buf cluster */
#define	MCLOFSET	(MCLBYTES - 1)	/* offset within a m_buf cluster */

#ifndef NMBCLUSTERS
#define	NMBCLUSTERS	2048		/* map size, max cluster allocation */
#endif

/*
 * Size of kernel malloc arena in CLBYTES-sized logical pages
 */ 
#ifndef NKMEMCLUSTERS
#define	NKMEMCLUSTERS	(16 * 1024 * 1024 / CLBYTES)
#endif

/* pages ("clicks") to disk blocks */
#define	ctod(x)		((x) << (PGSHIFT - DEV_BSHIFT))
#define	dtoc(x)		((x) >> (PGSHIFT - DEV_BSHIFT))

/* bytes to pages */
#define	ctob(x)		((x) << PGSHIFT)
#define	btoc(x)		(((x) + PGOFSET) >> PGSHIFT)

/* bytes to disk blocks */
#define	dbtob(x)	((x) << DEV_BSHIFT)
#define	btodb(x)	((x) >> DEV_BSHIFT)

/*
 * Mach derived conversion macros
 */
#define	i386_round_pdr(x)	((((unsigned)(x)) + PDOFSET) & ~PDOFSET)
#define	i386_trunc_pdr(x)	((unsigned)(x) & ~PDOFSET)
#define	i386_btod(x)		((unsigned)(x) >> PDSHIFT)
#define	i386_dtob(x)		((unsigned)(x) << PDSHIFT)
#define	i386_round_page(x)	((((unsigned)(x)) + PGOFSET) & ~PGOFSET)
#define	i386_trunc_page(x)	((unsigned)(x) & ~PGOFSET)
#define	i386_btop(x)		((unsigned)(x) >> PGSHIFT)
#define	i386_ptob(x)		((unsigned)(x) << PGSHIFT)

#include <limits.h>

#if !defined (PAGE_SIZE)
#define PAGE_SIZE 0x1000
#endif

#if !defined (HZ)
#define HZ        100
#endif
#if !defined (EOF)
#define EOF (-1)
#endif

#define	NBPW	sizeof(int)	/* number of bytes per word (integer) */

#define	CMASK	022		/* default file mask: S_IWGRP|S_IWOTH */
#define	NODEV	(dev_t)(-1)	/* non-existent device */

/*
 * Clustering of hardware pages on machines with ridiculously small
 * page sizes is done here.  The paging subsystem deals with units of
 * CLSIZE pte's describing NBPG (from machine/machparam.h) pages each.
 */
#define	CLBYTES		(CLSIZE*NBPG)
#define	CLOFSET		(CLSIZE*NBPG-1)	/* for clusters, like PGOFSET */
#define	claligned(x)	((((int)(x))&CLOFSET)==0)
#define	CLOFF		CLOFSET
#define	CLSHIFT		(PGSHIFT+CLSIZELOG2)

#if CLSIZE==1
#define	clbase(i)	(i)
#define	clrnd(i)	(i)
#else
/* Give the base virtual address (first of CLSIZE). */
#define	clbase(i)	((i) &~ (CLSIZE-1))
/* Round a number of clicks up to a whole cluster. */
#define	clrnd(i)	(((i) + (CLSIZE-1)) &~ (CLSIZE-1))
#endif

#define	CBLOCK	64		/* Clist block size, must be a power of 2. */
#define CBQSIZE	(CBLOCK/NBBY)	/* Quote bytes/cblock - can do better. */
				/* Data chars/clist. */
#define	CBSIZE	(CBLOCK - sizeof(struct cblock *) - CBQSIZE)
#define	CROUND	(CBLOCK - 1)	/* Clist rounding. */

/* File system parameters and macros. */

#ifndef _POSIX_OS2_ROOT
extern __const__ char*_getPosixOS2Root(void);
#define _POSIX_OS2_ROOT 	_getPosixOS2Root();
#endif 

/*
  LINK_MAX 
          maximum value of a file's link count

  MAX_CANON 
          maximum number of bytes in a terminal canonical input line

  MAX_INPUT 
          maximum number of bytes for which space will be available in a
          terminal input queue

  NAME_MAX 
          maximum number of bytes in a file name

  PATH_MAX 
          maximum number of bytes in a path name

  PIPE_BUF 
          maximum number of bytes that can be written atomically to a pipe 

  _POSIX_NO_TRUNC 
          path name components longer than NAME_MAX generate an error

  _POSIX_VDISABLE 
          terminal special characters can be disabled using this character value, 
          if it is defined
  
  See POSIX.1 for more details. 

 * The file system is made out of blocks of at most MAXBSIZE units, with
 * smaller units (fragments) only in the last direct block.  MAXBSIZE
 * primarily determines the size of buffers in the buffer pool.  It may be
 * made larger without any effect on existing file systems; however making
 * it smaller makes some file systems unmountable.
 */

/*
 * MAXPATHLEN defines the longest permissable path length after expanding
 * symbolic links. It is used to allocate a temporary buffer from the buffer
 * pool in which to do the name expansion, hence should be a power of two,
 * and must be less than or equal to MAXBSIZE.  MAXSYMLINKS defines the
 * maximum number of symbolic links that may be expanded in a path name.
 * It should be set high enough to allow all legitimate uses, but halt
 * infinite loops reasonably quickly.
 */
 /* max bytes of fully qualified path name: a file system property */
#ifndef PATH_MAX  /* OS/2 does not use a constant but a FS query */
extern __const__ int _mxPath(void); /* return max path length or -1 (error) */
#define PATH_MAX 260 
#endif /* ! PATH_MAX */

#define NAME_MAX   	PATH_MAX   /* max bytes in a file name (safe?) */

#ifndef MAXPATHLEN 
#define MAXPATHLEN 	PATH_MAX
#endif
#if !defined (MAXNAMLEN)
#define MAXNAMLEN  MAXPATHLEN 
#endif
#if !defined (FILENAME_MAX)
#define	FILENAME_MAX    PATH_MAX	/* must be <= PATH_MAX */
#endif
#define	MAXSYMLINKS	3		/* fake with copy for now */

#define	LINK_MAX   32767	/* fake max file link count: no hard links! */

/* System V/ANSI C; this is the wrong way to do this, do *not* use these. */
#if !defined (P_tmpdir)
# define	P_tmpdir	"/var/tmp/"
# define	L_tmpnam	PATH_MAX /* XXX must be == PATH_MAX */
#endif
#if !defined (TMP_MAX)
#define TMP_MAX         1000
#endif

  /* the following defaults are probably too small, but you can redefine them */
#if !defined (BUFSIZ)
#define BUFSIZ 5120
#endif
#if !defined (FOPEN_MAX)
#define	FOPEN_MAX	14	/* must be <= OPEN_MAX */
#endif 		/* FOPEN_MAX is a minimum maximum; should be the number of 
 * descriptors that the kernel can provide without allocation of a resource 
 * that can fail without the process sleeping.  Do not use this for anything. */

#ifndef RE_DUP_MAX
#define	RE_DUP_MAX	  255	/* max RE's in interval notation */
#endif

#define	MAXPARTITIONS	26		/* number of partitions */
/*
 * The absolute maximum number of disk partitions allowed.
 * This is the maximum value of MAXPARTITIONS for which 'struct disklabel'
 * is <= DEV_BSIZE bytes long.  If MAXPARTITIONS is greater than this, beware.
 */
#define	MAXMAXPARTITIONS	26
#if MAXPARTITIONS > MAXMAXPARTITIONS
#warning beware: MAXPARTITIONS bigger than MAXMAXPARTITIONS
#endif


#define	COLL_WEIGHTS_MAX	    2	/* max weights for order keyword */
#define	EXPR_NEST_MAX		   32	/* max expressions nested in expr(1) */
#define	LINE_MAX		 5120	/* max bytes in an input line (safe?) */
#define	IOV_MAX			 1024	/* max # of iov's (readv,sendmsg,etc) */

	/* BSD names for some <limits.h> values.  */
#define	NBBY		      CHAR_BIT
#define	BC_BASE_MAX	      INT_MAX	/* max ibase/obase values in bc(1) */
#define	BC_DIM_MAX		65535	/* max array elements in bc(1) */
#define	BC_SCALE_MAX	      INT_MAX	/* max scale value in bc(1) */
#define	BC_STRING_MAX	      INT_MAX	/* max const string length in bc(1) */

#if !defined (NULL)
#if defined (__cplusplus)
#define NULL 0
#else
#define NULL ((void *)0)
#endif
#endif

/* Bit map related macros. */
#define	setbit(a,i)	((a)[(i)/NBBY] |= 1<<((i)%NBBY))
#define	clrbit(a,i)	((a)[(i)/NBBY] &= ~(1<<((i)%NBBY)))
#define	isset(a,i)	((a)[(i)/NBBY] & (1<<((i)%NBBY)))
#define	isclr(a,i)	(((a)[(i)/NBBY] & (1<<((i)%NBBY))) == 0)

/*
 * Scale factor for scaled integers used to count %cpu time and load avgs.
 *
 * The number of CPU `tick's that map to a unique `%age' can be expressed
 * by the formula (1 / (2 ^ (FSHIFT - 11))).  The maximum load average that
 * can be calculated (assuming 32 bits) can be closely approximated using
 * the formula (2 ^ (2 * (16 - FSHIFT))) for (FSHIFT < 15).
 *
 * For the scheduler to maintain a 1:1 mapping of CPU `tick' to `%age',
 * FSHIFT must be at least 11; this gives us a maximum load avg of ~1024.
 */
#define	FSHIFT	11		/* bits to right of fixed binary point */
#define FSCALE	(1<<FSHIFT)

/* Macros for counting and rounding. */
#ifndef howmany
#define	howmany(x, y)	(((x)+((y)-1))/(y))
#endif
#define	roundup(x, y)	((((x)+((y)-1))/(y))*(y))
#define powerof2(x)	((((x)-1)&(x))==0)

/* Macros for min/max. */
#ifndef _KERNEL
#define	MIN(a,b) (((a)<(b))?(a):(b))
#define	MAX(a,b) (((a)>(b))?(a):(b))
#endif

/* Don't try to do this inline for now */

#if !defined (htonl)
#define htonl(X) _swapl(X)
#define ntohl(X) _swapl(X)
#define htons(X) _swaps(X)
#define ntohs(X) _swaps(X)
#endif

unsigned short _swaps(unsigned short _x);
unsigned long _swapl(unsigned long _x);

#if defined (__cplusplus)
}
#endif
#endif /* not _SYS_PARAM_H */
