#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <stdio.h>
#include <stdlib.h>

/* test segment leakage */
int main(void)
{
  int shmid, i;
  void *addr;
  struct shmid_ds buf;

	__SHMx_shmInit();
  shmid = shmget(IPC_PRIVATE, 1024, 0777);
  addr = shmat(shmid, 0, 0);
  for (i = 1; i < 150; i++) {
      shmid = shmget(IPC_PRIVATE, 1024, 0777);
      if (shmid >= 0) {
	  addr = shmat(shmid, 0, 0);
	  shmdt(addr);
	  shmctl(shmid, IPC_RMID, &buf);
	}
			else {
	  fprintf(stderr, "shmget() Error...(i = %d) wait for 10sec\n", i);
	  perror("Error");
	  sleep(10);
	  exit(1);
	}
			_SHMx_showActiveSeg();
    }
  exit(0);
}

