/* 	$Id: shmx.c,v 1.5 2000/04/26 13:17:20 veit Exp $ 	*/

#define INCL_DOSPROCESS
#define INCL_DOSMEMMGR
#include <os2.h>

#include <sys/builtin.h>
#include <sys/smutex.h>
#include <sys/types.h>
#include <machine/param.h>
#include <sys/ucred.h>
#define _KERNEL
#include <sys/ipc.h>
#include <sys/shm.h>
#include <errno.h>
#include <sys/errnox.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/*
 * Provides the following externally accessible functions:
 *
 * shminit(void);	                            - initialization
 * shmexit(struct vmspace*)                   - cleanup
 * shmfork(struct vmspace*, struct vmspace*)  - fork handling (not supported)
 * shmsys(arg1, arg2, arg3, arg4); = shm{at,ctl,dt,get}(arg2, arg3, arg4)
 *
 * Global structures:
 * shmsegs (an array of 'struct shmid_ds')
 * per proc array of 'struct shmmap_state' (not supported)
 */

/* Parts:
 * Copyright (c) 1994 Adam Glass and Charles M. Hannum.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Adam Glass and Charles M.
 *	Hannum.
 * 4. The names of the authors may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#define	SHMSEG_FREE     	0x0200
#define	SHMSEG_REMOVED  	0x0400
#define	SHMSEG_ALLOCATED	0x0800
#define	SHMSEG_WANTED		0x1000

struct shmid_ds __SHMx_shmsegs[SHMMNI];             /* shared data objects */
struct shmid_ds *__SHMx_shmsegs_p[SHMMNI] = {IPC_UNUSED}; /* point to data */

unsigned char __SHMx_defer_rm[SHMMNI];
_smutex __SHMx_shm_lock = 0;

/*
 * System 5 style catch-all structure for shared memory constants that
 * might be of interest to user programs. 
 * global info struct about shm-related values
 */
struct	_shminfo 
__SHMx_shminfo = {
	SHMMAX,
	SHMMIN,
	SHMMNI,
	SHMSEG,
	SHMALL
};

static unsigned long shm_nused = 0; /* every used id is <= max_nused */

/* You must initialize shm! The dll init does it for you, if you are lucky.
 */
	extern void 
__SHMx_shmInit(void)
{
 register int i = 0;
	/* initialize on instance */
	shminfo.shmmax *= NBPG; /* bytes/page: 0x1000 */

        _dPuts("shm_init()\n");
        _smutex_request(&shm_lock);
	
	for (; i < SHMMNI; ++i) {
		shmsegs_p[i] = (struct shmid_ds*)IPC_UNUSED;
		shmsegs[i].shm_perm.mode = SHMSEG_FREE;
		shmsegs[i].shm_perm.seq = 0;
	}
        _smutex_release(&shm_lock);
}

/*
 * Check user, group, other permissions for access
 * to ipc resources. return 0 if allowed
 */
	extern int
ipcperm(struct ucred *cred, struct ipc_perm *perm, int mode)
{  /* flag will most probably be 0 or S_...UGO */
 int requested_mode, granted_mode;

		/* we don't have credentials for now: */
	if (cred) if (mode == IPC_M) {
		if (cred->cr_uid == 0 ||
		    cred->cr_uid == perm->uid ||
		    cred->cr_uid == perm->cuid)
			return (0);
		errno =  EPERM; 		
		return(-1);
	}
	requested_mode = (mode >> 6) | (mode >> 3) | mode;
	granted_mode = perm->mode;
	granted_mode >>= 6;
	/* is there some bit set in requested_mode but not in granted_mode? */
	if (requested_mode & ~granted_mode & 0007) {
		errno = EACCES; 
		return -1;
        }
	return 0;
}

	static __inline__ int
shm_find_segment_by_key(key_t key)
{
	register unsigned int i = 0;

	while (i < shminfo.shmmni) {
                        _smutex_request(&shm_lock);
		_dPuts("shm_find_segment_by_key()...\n");
		if ( (shmsegs[i].shm_perm.mode & SHMSEG_ALLOCATED)
			 && shmsegs[i].shm_perm.key == key ) {
                        _smutex_release(&shm_lock);
			return(i);
                }
		++i;
        }
	_smutex_release(&shm_lock);
	return(-1);
}
	
	static struct shmid_ds *
shm_find_segment_by_shmid(int shmid)
{
 const unsigned int segnum = IPCID_TO_IX(shmid);
 struct shmid_ds *shmseg;

	if (segnum >= shminfo.shmmni)
		return NULL;
	shmseg = shmsegs_p[segnum];
	if ( shmseg == IPC_NOID || shmseg == IPC_UNUSED
	  || shmseg->shm_perm.seq != IPCID_TO_SEQ(shmid) )
		return NULL;
	return(shmseg);
}

/*
 * allocate new shmid_ds. protected by shmsegs[id] = NOID.
 */
	static __inline__ int 
newseg(key_t key, int shmflg, size_t size)
{
 register unsigned int id = 0;

	if (size < shminfo.shmmin || size > shminfo.shmmax)
		{errno = EINVAL; return(-1);}
	if (shm_nused >= shminfo.shmmni) /* any shmids left? */
		{errno = ENOSPC; return(-1);}
			
	for (;id < shminfo.shmmni; ++id) {
		if (shmsegs_p[id] == IPC_UNUSED) {
                        _smutex_request(&shm_lock);
			shmsegs_p[id] = (struct shmid_ds*)IPC_NOID;
			break;
                }
	} {
 struct shmid_ds *seg_p = &shmsegs[id];
 const APIRET 
	rc = DosAllocSharedMem(&seg_p->shm_pages, NULL, size,
        		OBJ_GETTABLE | PAG_COMMIT | PAG_READ | PAG_WRITE);
        if (rc) {
		_dPrintf("\
libext: newseg(): DosAllocSharedMem(): Error: rc = %lu\n",rc);
					shmsegs_p[id] = (struct shmid_ds*)IPC_UNUSED;
                _smutex_release(&shm_lock);
					errno = _rc2Errno(rc); return(-1);
        } else
          _dPuts("DosAllocSharedMem() successful\n");

	seg_p->shm_perm.key = key;
	seg_p->shm_perm.mode = shmflg;
	seg_p->shm_perm.cuid = seg_p->shm_perm.uid = 0;
	seg_p->shm_perm.cgid = seg_p->shm_perm.gid = 0;
	seg_p->shm_perm.seq  = (seg_p->shm_perm.seq + 1) & 0x7fff;
	seg_p->shm_segsz = size;
	seg_p->shm_cpid = getpid();
	seg_p->shm_lpid = seg_p->shm_nattch = 0;
	seg_p->shm_atime = seg_p->shm_dtime = 0;
	seg_p->shm_ctime = time(NULL);

	++shm_nused;
	shmsegs_p[id] = seg_p;
	defer_rm[id] = 0;
        _smutex_release(&shm_lock);
        _dPuts("newseg() successful\n");
	id = IXSEQ_TO_IPCID(id, seg_p->shm_perm);
  return(id); 
 }
}

/*
 * Here pages and shmid_ds are freed.
 */
	static __inline__ void 
killseg(struct shmid_ds *shp)
{
 APIRET rc;

	if (shp == IPC_NOID || shp == IPC_UNUSED || !shp->shm_pages)
		{errno = EFAULT; return;}

	++shp->shm_perm.seq;     /* for shmat: Increment the the internal 
			unique sequence number counter */

	/* DosFreeMem() decrements a reference count, so it should be */
	rc = DosFreeMem(shp->shm_pages); 	       /* called in shmdt() */
	if (rc) {
		_dPuts("libext: killseg(): DosFreeMem() failed\n");
		errno = _rc2Errno(rc);
		_dPrintf("DosFreeMem returned error code # %lu\n",rc);
		return;
        }
	_dPuts("libext: killseg(): DosFreeMem() successful\n");
	shp = (struct shmid_ds*)IPC_UNUSED;
	while ( (shmsegs_p[shm_nused] == (struct shmid_ds*)IPC_UNUSED) 
			&& shm_nused > 0 )
		--shm_nused;
}

	extern void 
__SHMx_shmDone(void)
        {
 register unsigned int id = 0;

	_dPuts("shm_done()\n");
	for (; id < SHMMNI; ++id) {
			_smutex_request(&shm_lock);
			shmsegs_p[id] = (struct shmid_ds*)IPC_UNUSED;
			killseg(shmsegs_p[id]);
			_smutex_release(&shm_lock);
        }
        }
	extern int 
shmctl(int shmid, int cmd, struct shmid_ds *buf)
{
	if (cmd < 0 || shmid < 0)
                {errno = EINVAL; return(-1);}
 {
 struct shmid_ds *shmseg = shm_find_segment_by_shmid(shmid);

	if (shmseg == NULL)
		{errno =  EINVAL; return(-1);}

        switch (cmd) {
        case IPC_STAT:
                if (!buf)
				{errno = EFAULT; return(-1);}
			if ((unsigned)shmid > shm_nused)
				{errno = EINVAL; return(-1);}
			if (shmseg == IPC_UNUSED || shmseg == IPC_NOID)
				{errno = EINVAL; return(-1);}
			if (ipcperm(NULL, &(shmseg->shm_perm), S_IRUGO))
				return(-1);
			memcpy(buf, shmseg, sizeof(*buf));
			return(0);
        case IPC_SET:
			if ((ipcperm(NULL, &shmseg->shm_perm, IPC_M)))
				return(-1);
			shmseg->shm_perm.uid = buf->shm_perm.uid;
			shmseg->shm_perm.gid = buf->shm_perm.gid;
			shmseg->shm_perm.mode =
					(shmseg->shm_perm.mode & ~ACCESSPERMS) |
					(buf->shm_perm.mode & ACCESSPERMS);
			shmseg->shm_ctime = time(NULL);
			break;
		case IPC_RMID: {
		 const unsigned id = IPCID_TO_IX(shmid);
			if (shmseg->shm_nattch <= 0) {
                  _smutex_request(&shm_lock);
				defer_rm[id] = 0;
				killseg(shmsegs_p[id]);
                  _smutex_release(&shm_lock);
                }
		else
		  defer_rm[id] = 1;
                break;
		}
		case SHM_LOCK:
		case SHM_UNLOCK:
        default:
			errno = EINVAL;
			return(-1);
	}
        }
        return 0;
}

	extern int 
shmget(key_t key, int size, int shmflg)
{
 struct shmid_ds *segnum;
 register int id = 0;

        if (size < 0 || size > SHMMAX)
		{errno = EINVAL; return(-1);}
        if (key == IPC_PRIVATE)
                return newseg(key, shmflg, (size_t)size);
        if ((id = shm_find_segment_by_key(key)) == -1) {
                if (!(shmflg & IPC_CREAT))
			{errno = ENOENT; return(-1);}
                return newseg(key, shmflg, (size_t)size);
        }
        if ((shmflg & IPC_CREAT) && (shmflg & IPC_EXCL))
		{errno = EEXIST; return(-1);}
        segnum = shmsegs_p[id];
        if (size > segnum->shm_segsz)
		{errno = EINVAL; return(-1);}
        if (__SHMx_ipcperm(NULL, &segnum->shm_perm, shmflg))
		{errno = EACCES; return(-1);}
        _dPuts("shmget() successful");
        return (unsigned int) segnum->shm_perm.seq * SHMMNI + id;
        }


/*
 * Fix shmaddr, allocate descriptor, map shm, add attach descriptor to lists.
 */
extern void *
shmat(const int shmid, const void *shmaddr, int shmflg)
{
        struct shmid_ds *shp;
 const unsigned int segnum = IPCID_TO_IX(shmid);

	if (segnum >= shminfo.shmmni)
                {errno = EINVAL; return (void*)NULL;}

	shp = shmsegs_p[segnum];

	if (shp == IPC_UNUSED || shp == IPC_NOID)
                {errno = EINVAL; return (void*)NULL;}

        if (shmaddr) { /* just ignore for now */
        	;
        } else _dPuts("shmat() 1 ...\n");

        if (ipcperm(NULL, &shp->shm_perm, shmflg & SHM_RDONLY ? 
        		S_IRUGO : S_IRUGO|S_IWUGO))
          {errno = EACCES; return (void *)NULL;} 
        if (shp->shm_perm.seq != IPCID_TO_SEQ(shmid))
          {errno = EIDRM; return(void*)NULL;}

_dPuts("shmat() 2 ...\n");

        ++shp->shm_nattch;            /* prevent destruction */

        shp->shm_lpid = getpid();
        shp->shm_atime = time(NULL);
        {APIRET rc = 
        DosGetSharedMem(shp->shm_pages, PAG_READ | PAG_WRITE );
        if (rc) {
                _dPuts("DosGetSharedMem() failed\n");
                errno = _rc2Errno(rc);
                return(void*)NULL;
        } else
          _dPuts("DosGetSharedMem() successful\n");
        }
        return(shp->shm_pages);
}

/*
 * detach segment
 */
extern int 
shmdt(const void *shmaddr)
{
 register unsigned int id = 0;
        struct shmid_ds *shp;

  for (;id <= shm_nused; ++id) {
		while ((shp = shmsegs_p[id]) == IPC_NOID) {
                        _smutex_request(&shm_lock);
                        _smutex_release(&shm_lock);
                }
                if (shp == IPC_UNUSED)
                        continue;
                if (((caddr_t)shp->shm_pages <= (caddr_t)shmaddr)
                && ((caddr_t)shmaddr <= ((caddr_t)shp->shm_pages
                									+ shp->shm_segsz))) {
                        if (shp->shm_nattch) {
			  --shp->shm_nattch;
			/* DosFreeMem() decrements a reference count,
			   so it should be called here */
				if (shp->shm_nattch) DosFreeMem(shp->shm_pages);
			}
			if (shp->shm_nattch == 0 && defer_rm[id]) {
				defer_rm[id] = 0;
				killseg(shmsegs_p[id]);
			}

                        _dPuts("shmdt() successful\n");
                        return IPC_PRIVATE;
                }
        }
        return (int) IPC_UNUSED;
}

#ifdef DEBUG
/* Display information about active shared memory segments */
	extern void
_SHMx_showActiveSeg(void)
{
 register unsigned int id = 0;
        struct shmid_ds *shp;

	printf("\nactive shared memory segments\n");
	for (;id < shm_nused; ++id) {
		while ((shp = shmsegs_p[id]) == IPC_NOID) {
                        _smutex_request(&shm_lock);
                        _smutex_release(&shm_lock);
                }
                if (shp != IPC_UNUSED || defer_rm[id]) {
                        _smutex_request(&shm_lock);
			printf("# = %d, key = %ld, nattch = %d\n",
				id, shp->shm_perm.key, shp->shm_nattch);
                        _smutex_release(&shm_lock);
                }
        }
}
#endif

