/*
 * Tree search generalized from Knuth (6.2.2) Algorithm T just like
 * the AT&T man page says.
 *
 * The node_t structure is for internal use only, lint doesn't grok it.
 *
 * Written by reading the System V Interface Definition, not the code.
 *
 * Totally public domain.
 */
/*LINTLIBRARY*/

#include <search.h>

typedef struct node_t {
    char	  *key;
    struct node_t *leftlink, *rightlink;
} node;

/* find or insert datum into search tree */
	extern void *
tsearch(const void*vkey, void**vrootp, int(*compar)(const void*,const void*))
	/* const void 	*vkey;		key to be located 
	   void		**vrootp;	address of tree root */
	
{
    register node *q;
    char *key = (char *)vkey;
    node **rootp = (node **)vrootp;

    if (rootp == (struct node_t **)0)
	return ((void *)0);
    while (*rootp != (struct node_t *)0) {	/* Knuth's T1: */
	int r;

	if ((r = (*compar)(key, (*rootp)->key)) == 0)	/* T2: */
	    return ((void *)*rootp);		/* we found it! */
	rootp = (r < 0) ?
	    &(*rootp)->leftlink :		/* T3: follow left branch */
	    &(*rootp)->rightlink;		/* T4: follow right branch */
    }
    q = (node *) malloc(sizeof(node));	/* T5: key not found */
    if (q != (struct node_t *)0) {	/* make new node */
	*rootp = q;			/* link new node to old */
	q->key = key;			/* initialize new node */
	q->leftlink = q->rightlink = (struct node_t *)0;
    }
    return ((void *)q);
}

/* delete node with given key */
	extern void *
tdelete(const void*vkey, void**vrootp, int(*compar)(const void*,const void*))
	/* const void	*vkey;		key to be deleted 
	   void		**vrootp;	address of the root of tree */
{
    node **rootp = (node **)vrootp;
    char *key = (char *)vkey;
    node *p;
    register node *q;
    register node *r;
    int cmp;

    if (rootp == (struct node_t **)0 || (p = *rootp) == (struct node_t *)0)
	return ((struct node_t *)0);
    while ((cmp = (*compar)(key, (*rootp)->key)) != 0) {
	p = *rootp;
	rootp = (cmp < 0) ?
	    &(*rootp)->leftlink :		/* follow left branch */
	    &(*rootp)->rightlink;		/* follow right branch */
	if (*rootp == (struct node_t *)0)
	    return ((void *)0);		/* key not found */
    }
    r = (*rootp)->rightlink;			/* D1: */
    if ((q = (*rootp)->leftlink) == (struct node_t *)0)	/* Left (struct node_t *)0? */
	q = r;
    else if (r != (struct node_t *)0) {		/* Right link is null? */
	if (r->leftlink == (struct node_t *)0) {	/* D2: Find successor */
	    r->leftlink = q;
	    q = r;
	} else {			/* D3: Find (struct node_t *)0 link */
	    for (q = r->leftlink; q->leftlink != (struct node_t *)0; q = r->leftlink)
		r = q;
	    r->leftlink = q->rightlink;
	    q->leftlink = (*rootp)->leftlink;
	    q->rightlink = (*rootp)->rightlink;
	}
    }
    free((struct node_t *) *rootp);	/* D4: Free node */
    *rootp = q;				/* link parent to new node */
    return(p);
}

/* Walk the nodes of a tree */
	static void
trecurse(node*root, void(*action)(const void*,VISIT, int), int level)
	/* root: Root of the tree to be walked */
	/* action: Function to be called at each node */
{
    if (root->leftlink == (struct node_t *)0 && root->rightlink == (struct node_t *)0)
	(*action)(root, leaf, level);
    else {
	(*action)(root, preorder, level);
	if (root->leftlink != (struct node_t *)0)
	    trecurse(root->leftlink, action, level + 1);
	(*action)(root, postorder, level);
	if (root->rightlink != (struct node_t *)0)
	    trecurse(root->rightlink, action, level + 1);
	(*action)(root, endorder, level);
    }
}

/* Walk the nodes of a tree */
	extern void
twalk(const void*vroot, void(*action)(const void*,VISIT, int))
	 /* vroot: Root of the tree to be walked */
{
    node *root = (node *)vroot;

    if (root != (node *)0 && action != (void(*)())0)
	trecurse(root, action, 0);
}


/* find a node, or return 0 */
	extern void *
tfind(const void*vkey, void*const*vrootp, int(*compar)(const void*,const void*))
{
    char *key = (char *)vkey;
    node **rootp = (node **)vrootp;

    if (rootp == (struct node_t **)0)
	return ((struct node_t *)0);
    while (*rootp != (struct node_t *)0) {	/* T1: */
	int r;
	if ((r = (*compar)(key, (*rootp)->key)) == 0)	/* T2: */
	    return (*rootp);		/* key found */
	rootp = (r < 0) ?
	    &(*rootp)->leftlink :		/* T3: follow left branch */
	    &(*rootp)->rightlink;		/* T4: follow right branch */
    }
    return (node *)0;
}
