/* sys/stat.h (libext+gcc) - $Id: stat.h,v 1.8 2000/05/15 09:47:47 veit Exp $ */

#ifndef _SYS_STAT_H
#define _SYS_STAT_H

#if !defined (_SYS_TYPES_H)
#warning <sys/stat.h> requires <sys/types.h>
#include <sys/types.h>
#endif

#if defined(__cplusplus)
# ifndef __inline__ 
#  define __inline__ inline
# endif
extern "C" {
#endif

#if !defined (_STAT)
#define _STAT
struct stat {
  /* these are in PPG: */
  mode_t  st_mode;		/* inode protection mode */
  ino_t	  st_ino;		/* inode's number */
  dev_t	  st_dev;		/* inode's device */
  nlink_t st_nlink;		/* number of hard links */
  uid_t	  st_uid;		/* user ID of the file's owner */
  gid_t	  st_gid;		/* group ID of the file's group */
  off_t   st_size;		/* file size, in bytes */
  time_t  st_atime;             /* time of last access */
  time_t  st_mtime;             /* time of last modification */
  time_t  st_ctime;             /* time of last status change */

  /* not in PPG */
  dev_t	  st_rdev;		/* device type */
  long	  st_atimensec;	        /* BSD: nsec of last access */
  long	  st_ctimensec;         /* BSD: nsec of last file status change */
  long	  st_mtimensec;	        /* BSD: nsec of last data modification */
  long    st_attr;		/* OS/2 extension */
  long    st_reserved;		/* emx extension */
  int64_t st_blocks; 		/* blocks allocated for file */
  u_int32_t st_blksize; 	        /* preferred blocksize for I/O */
  u_int32_t st_flags;  		/* unused: user defined flags for file */
  u_int32_t st_gen;    		/* unused: file generation number  */
  int32_t st_lspare;  		/* unused */
  int64_t st_qspare[2]; 	/* unused */
};

#endif

#if !defined (S_IRUSR)
#define S_ISUID 04000
#define S_ISGID 02000
#define S_ISVTX 01000
#if !defined (_POSIX_SOURCE)
#define S_ISTXT S_ISVTX
#endif
#define S_IRWXU 00700
#define S_IRUSR 00400
#define S_IWUSR 00200
#define S_IXUSR 00100

#define S_IRWXG 00070
#define S_IRGRP 00040
#define S_IWGRP 00020
#define S_IXGRP 00010

#define S_IRWXO 00007
#define S_IROTH 00004
#define S_IWOTH 00002
#define S_IXOTH 00001

#define	S_ISGID 02000
#define	S_ISUID 04000
#endif

#if !defined (S_IFMT)
#ifndef _POSIX_SOURCE
#define S_IFMT   0170000  /* Mask for file type */
#define S_IFIFO  0010000  /* Pipe */
#define S_IFCHR  0020000  /* Character device */
#define S_IFDIR  0040000  /* Directory */
#define S_IFREG  0100000  /* Regular file */
#define S_IFSOCK 0140000  /* Socket */
#if 0
#define	S_IFLNK	 0120000  /* symbolic link */
#define	S_IFWHT  0160000  /* whiteout */
#define	S_ISVTX	 0001000  /* save swapped text even after use */
#endif
#endif

/* S_ISBLK */
#define S_ISCHR(m)  (((m) & S_IFMT) == S_IFCHR)
#define S_ISDIR(m)  (((m) & S_IFMT) == S_IFDIR)
#define S_ISREG(m)  (((m) & S_IFMT) == S_IFREG)
#define S_ISFIFO(m) (((m) & S_IFMT) == S_IFIFO)
#ifndef _POSIX_SOURCE
#define S_ISSOCK(m) (((m) & S_IFMT) == S_IFSOCK)

#if 0 			/* as yet no symbolic links implemented */
#define	S_ISLNK(m)  (((m) & S_IFMT) == S_IFLNK)	/* symbolic link */
#define	S_ISWHT(m)  (((m) & S_IFMT) == S_IFWHT)	/* whiteout */
#endif

#endif
#endif

int chmod (__const__ char *, int);
int fstat (int, struct stat *);
int mkdir (__const__ char *, long);
/* mkfifo() */
int stat (__const__ char *, struct stat *);
int umask (int);

#ifndef _POSIX_SOURCE

#if !defined (S_IREAD)
#define S_IREAD  0400     /* Owner: read */
#define S_IWRITE 0200     /* Owner: write */
#define S_IEXEC  0100     /* Owner: exec */
#endif

#define S_IRUGO 	(S_IRUSR|S_IRGRP|S_IROTH)
#define S_IWUGO 	(S_IWUSR|S_IWGRP|S_IWOTH)
#define	ACCESSPERMS	(S_IRWXU|S_IRWXG|S_IRWXO)			  /* 0777 */
#define	ALLPERMS	(S_ISUID|S_ISGID|S_ISTXT|S_IRWXU|S_IRWXG|S_IRWXO) /* 7777 */
#define	DEFFILEMODE	(S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH) /* 0666 */
#define S_BLKSIZE	512		/* block size used in the stat struct */

#endif

#if !defined (_POSIX_SOURCE) || defined (_WITH_UNDERSCORE)

int _chmod (__const__ char *, int);
int _fstat (int, struct stat *);
int _mkdir (__const__ char *, long);
/* _mkfifo() */
int _stat (__const__ char *, struct stat *);
int _umask (int);

#endif

#if defined (__cplusplus)
}
#endif

#include <sys/statx.h>

#endif /* not SYS_STAT_H */
